/*
 * Decompiled with CFR 0.152.
 */
package stordy;

import stordy.Vec2d;
import stordy.VirtualBulletHandler;

class TargetingData {
    Vec2d lastPosition;
    Vec2d lastMovement;
    long time;
    double lastEnergy;
    String name;
    private static Vec2d arenaSize;

    TargetingData(Vec2d positionVector, double velocity, double bearing, long currentTime) {
        this.lastPosition = positionVector.duplicate();
        this.lastMovement = new Vec2d(Math.sin(bearing) * velocity, Math.cos(bearing) * velocity);
        this.time = currentTime;
    }

    TargetingData(Vec2d positionVector, double velocity, double bearing, double energy, long currentTime, String name) {
        this(positionVector, velocity, bearing, currentTime);
        this.lastEnergy = energy;
        this.name = name;
    }

    public void updateLastKnownData(Vec2d positionVector, double velocity, double bearing, long currentTime) {
        this.lastPosition = positionVector.duplicate();
        this.lastMovement = new Vec2d(Math.sin(bearing) * velocity, Math.cos(bearing) * velocity);
        this.time = currentTime;
    }

    public void updateLastKnownData(Vec2d positionVector, double velocity, double bearing, double energy, long currentTime) {
        this.updateLastKnownData(positionVector, velocity, bearing, currentTime);
        double dEnergy = this.lastEnergy - energy;
        if (dEnergy > 0.0 && dEnergy < 3.0) {
            VirtualBulletHandler.getHandler().bulletFired(this.name, dEnergy, currentTime);
        }
        this.lastEnergy = energy;
    }

    public double getLastPositionBearing(double myx, double myy) {
        double ox = this.lastPosition.getX() - myx;
        double oy = this.lastPosition.getY() - myy;
        return Math.atan2(oy, ox);
    }

    public double predictBearingRadians(Vec2d firePosition, long currentTime, double fireEnergy) {
        long dTime = currentTime - this.time;
        Vec2d predictedPosition = this.getPredictedPosition(firePosition, (int)dTime, fireEnergy);
        Vec2d relPosition = predictedPosition.subtract(firePosition);
        return Math.atan2(relPosition.getX(), relPosition.getY());
    }

    public Vec2d getPredictedPosition(Vec2d firePosition, int dTime, double fireEnergy) {
        Vec2d predictedPosition = this.lastPosition.add(this.lastMovement.multiply(dTime));
        int bulletTime = 0;
        Vec2d blm = this.lastMovement.duplicate();
        int i = 0;
        while ((double)(++bulletTime) * (20.0 - 3.0 * fireEnergy) < Vec2d.getDistance(firePosition, predictedPosition)) {
            predictedPosition = predictedPosition.add(blm).limitXY(18.0, 18.0, arenaSize.getX() - 18.0, arenaSize.getY() - 18.0);
            if (i++ > 100) break;
        }
        return predictedPosition;
    }

    public double getDistance(double myx, double myy) {
        return Vec2d.getDistance(this.lastPosition, new Vec2d(myx, myy));
    }

    public Vec2d getLastPosition() {
        return this.lastPosition;
    }

    public int deltaTime(long currentTime) {
        return (int)(currentTime - this.time);
    }

    public static void setArenaSize(Vec2d value) {
        arenaSize = value;
    }
}

