/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.data;

import java.awt.Color;
import robocode.robocodeGL.LabelGL;
import robocode.robocodeGL.PointGL;
import robocode.robocodeGL.RenderElement;
import robocode.robocodeGL.system.GLRenderer;
import vuen.fractal.data.Gen;
import vuen.fractal.data.Memory;
import vuen.fractal.util.BotMath;

public class GenGL {
    GLRenderer renderer;
    Memory memory;
    Gen gen;
    int id;
    PointGL[] powerpt;
    LabelGL[] power;

    public void destroy() {
        this.renderer = null;
        this.gen = null;
    }

    public GenGL(Object renderer, Memory memory, Gen gen) {
        this.renderer = (GLRenderer)renderer;
        this.memory = memory;
        this.gen = gen;
        this.powerpt = new PointGL[memory.totalbots + 1];
        this.power = new LabelGL[memory.totalbots + 1];
        for (int i = 0; i <= memory.totalbots; ++i) {
            this.powerpt[i] = new PointGL();
            this.powerpt[i].setColor(Color.black);
            this.powerpt[i].setPosition((double)(70 + 110 * i), 40.0);
            this.power[i] = new LabelGL("pwr: - (-)");
            this.powerpt[i].addLabel(this.power[i]);
        }
    }

    public void init() {
        for (int i = 0; i <= this.memory.totalbots; ++i) {
            this.renderer.addRenderElement((RenderElement)this.powerpt[i]);
        }
    }

    public void draw() {
    }

    public void updatePower(int id) {
        this.power[id].setString("pwr: " + BotMath.round(this.gen.getAvgPower(id), 2) + " (" + BotMath.round(this.gen.rpower[id], 2) + ")");
    }
}

