/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.gun;

import java.awt.Color;
import robocode.robocodeGL.LabelGL;
import robocode.robocodeGL.LineGL;
import robocode.robocodeGL.PointGL;
import robocode.robocodeGL.RenderElement;
import robocode.robocodeGL.system.GLRenderer;
import vuen.fractal.gun.SegmentGun;

public class SegmentGunGL {
    GLRenderer renderer;
    SegmentGun gun;
    LineGL[] line;
    Color[] color;
    int depth = 0;
    LabelGL depthlabel;
    PointGL depthlabelpt;
    public static final double HEIGHT = 80.0;

    public void destroy() {
        for (int i = 0; i < this.gun.totalbins - 1; ++i) {
            this.line[i].remove();
            this.line[i] = null;
        }
        this.renderer = null;
        this.gun = null;
    }

    public void setDepth(int depth) {
        if (depth != this.depth) {
            this.depthlabel.setString("depth: " + depth);
        }
        this.depth = depth;
    }

    public SegmentGunGL(Object renderer, SegmentGun gun) {
        int i;
        this.renderer = (GLRenderer)renderer;
        this.gun = gun;
        this.color = new Color[256];
        for (i = 0; i < 256; ++i) {
            this.color[i] = new Color(255 - i, i, 0);
        }
        this.line = new LineGL[gun.totalbins - 1];
        for (i = 0; i < gun.totalbins - 1; ++i) {
            this.line[i] = new LineGL();
            this.line[i].setColor(this.color[255]);
        }
        this.depthlabelpt = new PointGL();
        this.depthlabelpt.setColor(Color.black);
        this.depthlabelpt.setPosition((double)(70 + 110 * gun.enemy), 75.0);
        this.depthlabel = new LabelGL("depth: 0");
        this.depthlabelpt.addLabel(this.depthlabel);
    }

    public void init() {
        for (int i = 0; i < this.gun.totalbins - 1; ++i) {
            this.renderer.addRenderElement((RenderElement)this.line[i]);
        }
        this.renderer.addRenderElement((RenderElement)this.depthlabelpt);
    }

    public void draw(float[] bin) {
        int i;
        double max = 0.01;
        for (i = 0; i < this.gun.totalbins; ++i) {
            if (!((double)bin[i] > max)) continue;
            max = bin[i];
        }
        for (i = 0; i < this.gun.totalbins - 1; ++i) {
            this.line[i].setLine((double)i * 100.0 / (double)(this.gun.totalbins + 1) + 20.0 + (double)(110 * this.gun.enemy), (double)bin[i] / max * 50.0 + 80.0, (double)(i + 1) * 100.0 / (double)(this.gun.totalbins + 1) + 20.0 + (double)(110 * this.gun.enemy), (double)bin[i + 1] / max * 50.0 + 80.0);
        }
    }
}

