/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.gun.axis;

import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.gun.SegmentGun;

public abstract class Axis {
    public FractalE robot;
    public Memory memory;
    public SegmentGun gun;
    public int enemy;
    public int target;
    public int bin = -1;
    public int amount = -1;

    public final void create(FractalE robot, Memory memory, SegmentGun gun, int enemy) {
        this.robot = robot;
        this.memory = memory;
        this.gun = gun;
        this.enemy = enemy;
        this.target = enemy > 0 ? 0 : 1;
        this.init();
    }

    public final int getBin() {
        return this.bin;
    }

    public final int getAmountOfBins() {
        if (this.amount == -1) {
            throw new NullPointerException("Amount of bins in " + this.getClass().getName() + " not set!");
        }
        return this.amount;
    }

    public final void resetBin() {
        this.bin = -1;
    }

    public void go() {
        if (this.enemy == 0) {
            this.target = this.memory.getTarget();
        }
        this.calculateBin();
    }

    protected abstract void init();

    protected abstract void calculateBin();

    public abstract float getReliability(int var1);
}

