/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.movement.manager;

import de._4geeks.robots.movement.buffers.SurferFlattener;
import de._4geeks.robots.movement.buffers.SurferSeg;
import de._4geeks.robots.movement.manager.SurferScan;
import de._4geeks.robots.movement.manager.SurferWave;
import de._4geeks.robots.utils.Pair;
import de._4geeks.robots.utils.SUtils;
import de._4geeks.robots.utils.apv.MovSim;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovementManager {
    public static final int BINS = 47;
    public static final double OPTIMAL_DISTANCE = 300.0;
    AdvancedRobot robot;
    MovSim sim;
    protected static double BFWidth;
    protected static double BFHeight;
    private static double WALL_STICK;
    public static Rectangle2D.Double fieldRect;
    private double enemyEnergy;
    private Point2D.Double robotLocation;
    private Point2D.Double enemyLocation;
    private ArrayList<SurferWave> enemyWaves;
    private SurferScan enemyScan;
    private SurferScan lastEnemyScan;
    private SurferWave currentWave;
    private static SurferSeg seg;
    private static SurferFlattener flat;

    static {
        WALL_STICK = 160.0;
    }

    public MovementManager(AdvancedRobot robot) {
        this.robot = robot;
        this.sim = new MovSim();
        this.enemyWaves = new ArrayList();
        if (fieldRect == null) {
            fieldRect = new Rectangle2D.Double(18.0, 18.0, robot.getBattleFieldWidth() - 18.0, robot.getBattleFieldHeight() - 18.0);
            BFWidth = robot.getBattleFieldWidth();
            BFHeight = robot.getBattleFieldHeight();
        }
        if (seg == null) {
            seg = new SurferSeg(47);
            flat = new SurferFlattener(47);
        }
        this.enemyEnergy = Double.MAX_VALUE;
        this.enemyScan = new SurferScan();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.robotLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        double absBearing = e.getBearingRadians() + this.robot.getHeadingRadians();
        double bulletPower = this.enemyEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09) {
            SurferWave ew = new SurferWave();
            ew.fireTime = this.robot.getTime() - 1L;
            ew.bulletVelocity = SUtils.bulletVelocity(bulletPower);
            ew.distanceTraveled = SUtils.bulletVelocity(bulletPower);
            ew.bulletPower = bulletPower;
            ew.scan = this.lastEnemyScan;
            ew.fireLocation = (Point2D.Double)this.enemyLocation.clone();
            this.enemyWaves.add(ew);
        }
        this.enemyEnergy = e.getEnergy();
        this.enemyLocation = SUtils.project(this.robotLocation, absBearing, e.getDistance());
        try {
            this.lastEnemyScan = this.enemyScan.clone();
            this.enemyScan.update(this.robot, e);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.updateWaves();
        this.doSurfing();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            SurferWave hitWave = null;
            double bulletPower = e.getBullet().getPower();
            for (SurferWave wave : this.enemyWaves) {
                if (!(Math.abs(wave.bulletPower - bulletPower) < 0.1) || !(wave.distanceTraveled - this.robotLocation.distance(wave.fireLocation) < 50.0)) continue;
                hitWave = wave;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(hitWave);
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            SurferWave hitWave = null;
            double bulletPower = e.getHitBullet().getPower();
            for (SurferWave wave : this.enemyWaves) {
                if (!(Math.abs(wave.bulletPower - bulletPower) < 0.1) || !(wave.distanceTraveled - this.robotLocation.distance(wave.fireLocation) < 50.0)) continue;
                hitWave = wave;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(hitWave);
            }
        }
    }

    protected void logHit(SurferWave wave, Point2D.Double loc) {
        seg.logHit(wave, loc);
    }

    protected void updateWaves() {
        long ctime = this.robot.getTime();
        Iterator<SurferWave> iter = this.enemyWaves.iterator();
        while (iter.hasNext()) {
            SurferWave wave = iter.next();
            wave.distanceTraveled = (double)(ctime - wave.fireTime) * wave.bulletVelocity;
            if (!(wave.distanceTraveled > this.robotLocation.distance(wave.fireLocation) + 50.0)) continue;
            flat.logHit(wave, this.robotLocation);
            iter.remove();
        }
    }

    protected void doSurfing() {
        List<Pair<SurferWave>> waves = this.getSurfableWaves();
        if (waves.size() > 2) {
            waves = waves.subList(0, 2);
        }
        if (waves.size() > 0 && this.currentWave != waves.get((int)0).item) {
            long t = System.nanoTime();
            this.currentWave = (SurferWave)waves.get((int)0).item;
            ArrayList<Point2D.Double> positions = this.getPossiblePositions(this.enemyLocation.distance(this.robotLocation));
            double[] dangerP = this.calculateDanger(waves, positions);
            double minDanger = Double.POSITIVE_INFINITY;
            Point2D.Double minPoint = new Point2D.Double(this.robot.getX(), this.robot.getY());
            int i = 0;
            while (i < dangerP.length) {
                double distance = this.robotLocation.distance(positions.get(i));
                int n = i;
                dangerP[n] = dangerP[n] * (1.0 + 300.0 / distance);
                if (dangerP[i] < minDanger) {
                    minPoint = positions.get(i);
                    minDanger = dangerP[i];
                }
                ++i;
            }
            this.currentWave.savestLocation = minPoint;
            t = System.nanoTime() - t;
            this.goTo(this.currentWave.savestLocation);
        }
    }

    protected double[] calculateDanger(List<Pair<SurferWave>> waves, ArrayList<Point2D.Double> positions) {
        double[] dangerP = new double[positions.size()];
        for (Pair<SurferWave> wave : waves) {
            seg.getDanger(wave, positions, dangerP);
        }
        return dangerP;
    }

    protected ArrayList<Point2D.Double> getPossiblePositions(double distance) {
        boolean flee = distance < 100.0;
        ArrayList<Point2D.Double> positions = this.predictPosition(this.currentWave, 1, 1, flee);
        Collections.reverse(positions);
        positions.addAll(this.predictPosition(this.currentWave, -1, 1, flee));
        if (Math.random() > 0.5) {
            Collections.reverse(positions);
        }
        return positions;
    }

    private void goTo(Point2D.Double point) {
        double distance = this.robotLocation.distance(point);
        double angle = Utils.normalRelativeAngle((double)(SUtils.absoluteBearing(this.robotLocation, point) - this.robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.robot.setTurnRightRadians(angle);
        this.robot.setAhead(distance);
    }

    protected ArrayList<Point2D.Double> predictPosition(SurferWave wave, int dir) {
        return this.predictPosition(wave, dir, 1, false);
    }

    protected ArrayList<Point2D.Double> predictPosition(SurferWave wave, int dir, int smoothDir, boolean flee) {
        Point2D.Double predictedPosition = (Point2D.Double)this.robotLocation.clone();
        double predictedVelocity = this.robot.getVelocity();
        double predictedHeading = this.robot.getHeadingRadians();
        double predictedDistance = predictedPosition.distance(wave.fireLocation);
        int counter = 0;
        boolean intercepted = false;
        ArrayList<Point2D.Double> positions = new ArrayList<Point2D.Double>();
        positions.add(predictedPosition);
        do {
            double distanceMod;
            double d = distanceMod = predictedDistance < 300.0 ? 0.9 : 1.1;
            if (predictedDistance < 150.0) {
                distanceMod = 0.5;
            }
            if (flee) {
                distanceMod = 0.0;
            }
            double moveAngle = this.wallSmoothing(predictedPosition.x, predictedPosition.y, SUtils.absoluteBearing(wave.fireLocation, predictedPosition) + (double)dir * distanceMod * 1.5707963267948966, dir, smoothDir) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + SUtils.limit(moveAngle, -maxTurning, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = SUtils.limit(predictedVelocity, -8.0, 8.0);
            predictedPosition = SUtils.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            predictedDistance = predictedPosition.distance(wave.fireLocation);
            if (predictedDistance < wave.distanceTraveled + (double)counter * wave.bulletVelocity + wave.bulletVelocity) {
                intercepted = true;
            }
            positions.add(predictedPosition);
        } while (!intercepted && counter < 500);
        return positions;
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!fieldRect.contains(SUtils.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * WALL_STICK;
        double testY = y + Math.cos(angle) * WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, BFWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, BFHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, BFWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, BFHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!fieldRect.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.005)) * WALL_STICK;
            testY = y + Math.cos(angle) * WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, BFWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, BFHeight - testY - 18.0);
        }
        return angle;
    }

    protected SurferWave getClosestSurfableWave() {
        double closestDistance = Double.POSITIVE_INFINITY;
        SurferWave closest = null;
        for (SurferWave wave : this.enemyWaves) {
            double distance = this.robotLocation.distance(wave.fireLocation) - wave.distanceTraveled;
            if (!(distance > wave.bulletVelocity) || !(distance < closestDistance)) continue;
            closest = wave;
            closestDistance = distance;
        }
        return closest;
    }

    protected ArrayList<Pair<SurferWave>> getSurfableWaves() {
        ArrayList<Pair<SurferWave>> waves = new ArrayList<Pair<SurferWave>>();
        for (SurferWave wave : this.enemyWaves) {
            double distance = this.robotLocation.distance(wave.fireLocation) - wave.distanceTraveled;
            double time = distance / wave.bulletPower;
            if (!(distance > wave.bulletVelocity)) continue;
            waves.add(new Pair<SurferWave>(time, wave));
        }
        Collections.sort(waves);
        return waves;
    }

    public void onPaint(Graphics2D g) {
        ArrayList<Pair<SurferWave>> waves;
        int i;
        int i2 = 0;
        while (i2 < this.enemyWaves.size()) {
            SurferWave w = this.enemyWaves.get(i2);
            if (w == this.currentWave) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.red);
            }
            Point2D.Double center = w.fireLocation;
            int radius = (int)w.distanceTraveled;
            if ((double)(radius - 40) < center.distance(this.robotLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i2;
        }
        if (this.currentWave != null) {
            g.setColor(Color.GREEN);
            double maxStats = 0.0;
            double[] stats = seg.getStats(this.currentWave);
            i = 0;
            while (i < 47) {
                if (stats[i] > maxStats) {
                    maxStats = stats[i];
                }
                ++i;
            }
            if (maxStats == 0.0) {
                maxStats = 0.1;
            }
            i = 1;
            while (i < 47) {
                g.drawLine(20 + (i - 1) * 5, (int)(20.0 + stats[i - 1] * 100.0 / maxStats), 20 + i * 5, (int)(20.0 + stats[i] * 100.0 / maxStats));
                ++i;
            }
        }
        if ((waves = this.getSurfableWaves()).size() > 0) {
            SurferWave wave = (SurferWave)waves.get((int)0).item;
            g.setColor(Color.MAGENTA);
            ArrayList<Point2D.Double> positions = this.predictPosition(wave, 1, 1, false);
            int j = 1;
            while (j < positions.size()) {
                g.drawOval((int)positions.get((int)j).x, (int)positions.get((int)j).y, 5, 5);
                ++j;
            }
            Point2D.Double p = positions.get(positions.size() - 1);
            i = MovementManager.getFactorIndex(wave, p);
            g.drawLine(20 + i * 5, 20, 20 + i * 5, 120);
            g.setColor(Color.CYAN);
            positions = this.predictPosition(wave, -1, 1, false);
            j = 1;
            while (j < positions.size()) {
                g.drawOval((int)positions.get((int)j).x, (int)positions.get((int)j).y, 5, 5);
                ++j;
            }
            p = positions.get(positions.size() - 1);
            i = MovementManager.getFactorIndex(wave, p);
            g.drawLine(20 + i * 5, 20, 20 + i * 5, 120);
        }
        if (this.currentWave != null) {
            g.setColor(Color.ORANGE);
            g.drawOval((int)this.currentWave.savestLocation.x, (int)this.currentWave.savestLocation.y, 5, 5);
        }
    }

    public static int getFactorIndex(SurferWave ew, Point2D.Double targetLocation) {
        double offsetAngle = SUtils.absoluteBearing(ew.fireLocation, targetLocation) - ew.scan.absBearing + Math.PI;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / SUtils.maxEscapeAngle(ew.bulletVelocity) * (double)ew.scan.direction;
        return (int)SUtils.limit(factor * 23.0 + 23.0, 0.0, 46.0);
    }
}

