/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile;

import cbot.agile.CU;
import cbot.agile.Nibbler;
import cbot.agile.Point;
import cbot.agile.StorageManager;
import cbot.agile.gun.Pattern;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Pray {
    public static Pattern pattern;
    private static int totFired;
    private static int totFired_short;
    private static int totFired_middle;
    private static int totFired_long;
    private static int totHit;
    private static int totHit_short;
    private static int totHit_middle;
    private static int totHit_long;
    private ArrayList bullets;
    private double bearing;
    private double bearingDelta;
    private double heading;
    private double headingDelta;
    private double velocity;
    private double velocityDelta;
    private double distance;
    private double energy;
    private String name;
    private Point cordinate;
    public Nibbler robot;
    private int timeDelta;
    private long time;
    private double lostEnergy;
    private double gainedEnergy;
    private double lastFirePower;
    double max;
    double min;

    public void update(ScannedRobotEvent e, Nibbler robot) {
        this.bearingDelta = e.getBearing() - this.bearing;
        this.bearing = e.getBearing();
        this.headingDelta = e.getHeading() - this.heading;
        this.heading = e.getHeading();
        this.velocity = e.getVelocity();
        this.velocityDelta = e.getVelocity() - this.velocity;
        this.distance = e.getDistance();
        this.cordinate = this.getPoint(robot, e);
        this.timeDelta = (int)(robot.getTime() - this.time);
        this.time = robot.getTime();
        this.logMove(e, robot);
        this.isFiring(e.getEnergy() - this.energy);
        this.energy = e.getEnergy();
    }

    public void gotHitByBullet(Bullet bullet) {
        this.lostEnergy = CU.getLostEnergyByBullet(bullet.getPower());
    }

    public void hitRobotWithBullet(Bullet bullet) {
        this.gainedEnergy = CU.getGainedEnergyByBullet(bullet.getPower());
        ++totHit;
        this.checkBullets();
    }

    public void saveData() {
        StorageManager.putObject(this.name, "patternMatcher.pattern", pattern.getTrackData());
    }

    public String getHittingRates() {
        return this.name + ": [" + totHit + '/' + totFired + "] " + CU.formatNumber((double)totHit / (double)totFired * 100.0) + '%';
    }

    private final void isFiring(double energyDelta) {
        double firePower = energyDelta + this.lostEnergy - this.gainedEnergy;
        this.gainedEnergy = 0.0;
        this.lostEnergy = 0.0;
        if (firePower < -0.001 && firePower >= -3.0) {
            this.lastFirePower = Math.abs(firePower);
            Nibbler.driver.handleBeingFiredAt(this, this.lastFirePower, this.time);
            ++totFired;
            double distance = this.robot.getCordinate().getDistance(this.cordinate);
            this.bullets.add(new PrayBullet(this.robot, this.cordinate, this.lastFirePower));
            if (distance < CU.DISTANCE_SHORT) {
                ++totFired_short;
            } else if (distance < CU.DISTANCE_MIDDLE) {
                ++totFired_middle;
            } else {
                ++totFired_long;
            }
        }
    }

    private final void logMove(ScannedRobotEvent e, AdvancedRobot robot) {
        if (robot.getTime() > 30L) {
            pattern.log(this.time, CU.normalRelativeAngle(this.headingDelta), this.velocity, this.velocityDelta);
        }
    }

    private final Point getPoint(Nibbler robot, ScannedRobotEvent sre) {
        Point reference = robot.getCordinate();
        double prayAbsBearing = sre.getBearingRadians() + robot.getHeadingRadians() - Math.PI * 2;
        return Point.getNewPoint(reference, this.distance, prayAbsBearing);
    }

    private final void checkBullets() {
        double minDiff = 100.0;
        double currentDistance = -1.0;
        int i = 0;
        while (i < this.bullets.size()) {
            PrayBullet pb = (PrayBullet)this.bullets.get(i);
            double diff = pb.getTravelDiff();
            if (diff < Math.abs(minDiff)) {
                minDiff = Math.abs(diff);
                currentDistance = pb.fireDistance;
            }
            if (diff > 20.0) {
                this.bullets.remove(pb);
            }
            ++i;
        }
        if (currentDistance < CU.DISTANCE_SHORT) {
            ++totHit_short;
        } else if (currentDistance < CU.DISTANCE_MIDDLE) {
            ++totHit_middle;
        } else {
            ++totHit_long;
        }
    }

    public boolean isDisabled() {
        boolean bl = false;
        if (this.energy == 0.0) {
            bl = true;
        }
        return bl;
    }

    public Pattern getPattern() {
        return pattern;
    }

    public double getFirePower() {
        return this.lastFirePower;
    }

    public double getLastFirePower() {
        return this.lastFirePower;
    }

    public long getTime() {
        return this.time;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getName() {
        return this.name;
    }

    public Point getCordinate() {
        return this.cordinate;
    }

    public double getBearingDelta() {
        return this.bearingDelta;
    }

    public long getTimeDelta() {
        return this.timeDelta;
    }

    public double getHeadingDelta() {
        return this.headingDelta;
    }

    private final /* synthetic */ void this() {
        this.bullets = new ArrayList(5);
        this.lostEnergy = 0.0;
        this.gainedEnergy = 0.0;
        this.lastFirePower = 0.0;
        this.max = 0.0;
        this.min = 0.0;
    }

    public Pray(ScannedRobotEvent e, Nibbler robot) {
        this.this();
        this.bearing = e.getBearing();
        this.heading = e.getHeading();
        this.velocity = e.getVelocity();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        this.name = e.getName();
        this.robot = robot;
        this.cordinate = this.getPoint(robot, e);
        this.time = robot.getTime();
        if (pattern == null) {
            pattern = new Pattern();
            pattern.init(StorageManager.getObject(this.name, "patternMatcher.pattern"));
        }
    }

    static {
        totFired = 0;
        totFired_short = 0;
        totFired_middle = 0;
        totFired_long = 0;
        totHit = 0;
        totHit_short = 0;
        totHit_middle = 0;
        totHit_long = 0;
    }

    class PrayBullet {
        double fireDistance;
        Point fireCord;
        long fireTime;
        double firePower;

        public double getTravelDiff() {
            double distance = Pray.this.robot.getCordinate().getDistance(this.fireCord);
            double travelTime = distance / CU.getBulletVelocity(this.firePower);
            double elapsedTime = Pray.this.robot.getTime() - this.fireTime;
            return CU.diff(travelTime, elapsedTime);
        }

        public PrayBullet(Nibbler r, Point fc, double fp) {
            this.fireDistance = Pray.this.distance;
            this.fireCord = fc;
            this.fireTime = r.getTime();
            this.firePower = fp;
        }
    }
}

