/*
 * Decompiled with CFR 0.152.
 */
package el;

import java.awt.Color;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class JumpShoot
extends Robot {
    public void run() {
        this.setColors(Color.blue, Color.green, Color.blue);
        while (true) {
            this.ahead(100.0);
            this.turnRight(180.0);
            this.back(100.0);
            this.turnGunLeft(270.0);
            this.ahead(60.0);
            this.back(50.0);
            this.turnLeft(180.0);
            this.ahead(90.0);
            this.turnGunRight(360.0);
        }
    }

    public void onHitWall(HitWallEvent event) {
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.back(200.0);
            this.turnRight(160.0);
            System.out.println("Wall collision detected! Backing up.");
        } else {
            this.ahead(200.0);
            this.turnRight(160.0);
            System.out.println("Wall collision detected! Moving forward.");
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.back(150.0);
        } else {
            this.ahead(150.0);
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.out.println("JumpShoot successfully hit " + event.getName() + '!');
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.fire(3);
        this.setBulletColor(Color.ORANGE);
        System.out.println("A bullet with a power of 3 has been shot!");
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.turnLeft(90.0 - e.getBearing());
        System.out.println("JumpShoot has been hit!");
    }

    public void onDeath(DeathEvent event) {
        System.out.println("JumpShoot has been destroyed...");
    }
}

