/*
 * Decompiled with CFR 0.152.
 */
package justin.movement;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import justin.Module;
import justin.Movement;
import justin.movement.microEnemy;
import robocode.Event;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class HoF
extends Movement {
    static final int m = 30;
    static Hashtable targets = new Hashtable();
    static microEnemy target = new microEnemy();
    static Point2D.Double myPos;
    static Point2D.Double lastPos;
    static double myEnergy;
    Point2D.Double next;

    public HoF(Module bot) {
        super(bot);
    }

    @Override
    public void move() {
        myPos = new Point2D.Double(this.bot.getX(), this.bot.getY());
        myEnergy = this.bot.getEnergy();
        this.doStuff();
    }

    public void doStuff() {
        double d;
        if (target == null || HoF.target.pos == null) {
            return;
        }
        int i = 0;
        Point2D.Double p = HoF.target.pos;
        double dist = myPos.distance(p);
        double angle = Math.min(Math.min(myEnergy / 6.0, 1300.0 / dist), HoF.target.energy / 3.0);
        if (this.next == null) {
            this.next = lastPos = myPos;
        }
        angle = myPos.distance(this.next);
        if (d < 15.0) {
            angle = 1.0 - Math.rint(Math.pow(Math.random(), this.bot.getOthers()));
            do {
                p = HoF.calcPoint(myPos, Math.min(dist * 0.8, 100.0 + 200.0 * Math.random()), Math.PI * 2 * Math.random());
                if (!new Rectangle2D.Double(30.0, 30.0, this.bot.getBattleFieldWidth() - 60.0, this.bot.getBattleFieldHeight() - 60.0).contains(p) || !(HoF.evaluate(p, angle) < HoF.evaluate(this.next, angle))) continue;
                this.next = p;
            } while (i++ < 100);
            lastPos = myPos;
        } else {
            double d2 = angle;
            angle = Utils.normalRelativeAngle((double)(HoF.calcAngle(this.next, myPos) - this.bot.getHeadingRadians()));
            this.bot.setAhead(d2 * (double)(angle != (angle = Math.atan(Math.tan(angle))) ? -1 : 1));
            this.bot.setTurnRightRadians(angle);
            this.bot.setMaxVelocity(Math.abs(angle) <= 1.0 ? 8.0 : 0.0);
        }
    }

    public static double evaluate(Point2D.Double p, double addLast) {
        double eval = addLast * 0.08 / p.distanceSq(lastPos);
        for (microEnemy en : targets.values()) {
            if (!en.live) continue;
            eval += Math.min(en.energy / myEnergy, 2.0) * (1.0 + Math.abs(Math.cos(HoF.calcAngle(myPos, p) - HoF.calcAngle(en.pos, p)))) / p.distanceSq(en.pos);
        }
        return eval;
    }

    @Override
    public void listen(Event e) {
        if (e instanceof ScannedRobotEvent) {
            String eName = ((ScannedRobotEvent)e).getName();
            microEnemy en = (microEnemy)targets.get(eName);
            if (en == null) {
                en = new microEnemy();
                targets.put(eName, en);
            }
            en.name = eName;
            en.energy = ((ScannedRobotEvent)e).getEnergy();
            en.live = true;
            en.pos = HoF.calcPoint(myPos, ((ScannedRobotEvent)e).getDistance(), this.bot.getHeadingRadians() + ((ScannedRobotEvent)e).getBearingRadians());
            if (!HoF.target.live || ((ScannedRobotEvent)e).getDistance() < myPos.distance(HoF.target.pos)) {
                target = en;
            }
        }
        if (e instanceof RobotDeathEvent) {
            ((microEnemy)HoF.targets.get((Object)((RobotDeathEvent)e).getName())).live = false;
        }
    }

    private static final Point2D.Double calcPoint(Point2D.Double p, double dist, double ang) {
        return new Point2D.Double(p.x + dist * Math.sin(ang), p.y + dist * Math.cos(ang));
    }

    private static final double calcAngle(Point2D.Double p2, Point2D.Double p1) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }
}

