/*
 * Decompiled with CFR 0.152.
 */
package ds;

import ds.DateTime;
import ds.PluggableRobot;
import ds.PositionLog;
import ds.constant.ConstantManager;
import ds.gun.GunManager;
import ds.movement.IMovementManager;
import ds.movement.MovementManager;
import ds.radar.Radar;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetManager;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Versatile
extends PluggableRobot
implements IVirtualBot {
    private static ITargetManager s_targetManager;
    private static Radar s_radar;
    private static GunManager s_gunManager;
    private static IMovementManager s_movementManager;
    private static final double ROBOT_SIZE = 40.0;
    private PositionLog m_positionLog;

    @Override
    protected void initializeBattle() {
        this.setColors(Color.black, Color.red, new Color(0x900000));
        this.setBulletColor(new Color(16731398));
        this.setScanColor(new Color(3570093));
        s_targetManager = new TargetManager(this);
        s_radar = new Radar(this, s_targetManager);
        s_gunManager = new GunManager(this, s_targetManager);
        s_movementManager = new MovementManager(this, s_targetManager);
    }

    @Override
    protected void initializeRound() {
        this.registerComponent(s_targetManager);
        this.registerComponent(s_radar);
        this.registerListener(s_radar);
        if (ConstantManager.getInstance().getBooleanConstant("debug")) {
            this.registerPainter(s_radar);
        }
        this.registerComponent(s_gunManager);
        if (ConstantManager.getInstance().getBooleanConstant("debug")) {
            this.registerPainter(s_gunManager);
        }
        if (ConstantManager.getInstance().getBooleanConstant("movement.active")) {
            this.registerComponent(s_movementManager);
            if (ConstantManager.getInstance().getBooleanConstant("debug")) {
                this.registerPainter(s_movementManager);
            }
        }
    }

    @Override
    public void update() {
        this.m_positionLog.add(new Point2D.Double(this.getX(), this.getY()));
    }

    @Override
    public void updateFromScan(AdvancedRobot referent, ScannedRobotEvent event) {
    }

    @Override
    public double getBearingRadians() {
        throw new NullPointerException();
    }

    @Override
    public double getAbsoluteBearingRadians() {
        throw new NullPointerException();
    }

    @Override
    public Point2D.Double getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public Point2D getUpperRightCorner() {
        return new Point2D.Double(this.getX() + 20.0, this.getY() + 20.0);
    }

    @Override
    public Point2D getBottomLeftCorner() {
        return new Point2D.Double(this.getX() - 20.0, this.getY() - 20.0);
    }

    @Override
    public double getSize() {
        return 40.0;
    }

    @Override
    public double getRelativeHeading() {
        throw new NullPointerException();
    }

    @Override
    public double getTurnRate() {
        throw new NullPointerException();
    }

    @Override
    public double getDistance() {
        throw new NullPointerException();
    }

    @Override
    public double getTimeSinceLastDeccel() {
        throw new NullPointerException();
    }

    @Override
    public double getTimeSinceLastAccel() {
        throw new NullPointerException();
    }

    @Override
    public double getTimeSinceLastVelocityInversion() {
        throw new NullPointerException();
    }

    @Override
    public double getTimeSinceLastVelocityChange() {
        throw new NullPointerException();
    }

    @Override
    public double getAcceleration() {
        throw new NullPointerException();
    }

    @Override
    public int getTimeSinceLastShot() {
        throw new NullPointerException();
    }

    @Override
    public int getTimeSinceLastDamageTaken() {
        throw new NullPointerException();
    }

    @Override
    public double getLastShotPower() {
        throw new NullPointerException();
    }

    @Override
    public double getLateralVelocity() {
        throw new NullPointerException();
    }

    @Override
    public double getLastNonNullLateralVelocity() {
        throw new NullPointerException();
    }

    @Override
    public double getLateralDirection() {
        throw new NullPointerException();
    }

    @Override
    public double getLateralAccell() {
        throw new NullPointerException();
    }

    @Override
    public DateTime getDateTime() {
        return new DateTime(this.getRoundNum(), this.getTime());
    }

    @Override
    public PositionLog getPositionLog() {
        return this.m_positionLog;
    }
}

