/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.AdvancedEnemyBot;
import deo.virtual.Gun;
import deo.virtual.Util;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;

public class PredictiveTargetingGun
extends Gun {
    PredictiveTargetingGun() {
    }

    @Override
    public double getFireAngle(AdvancedRobot shooter, AdvancedEnemyBot e, double bulletPower) {
        Point2D.Double myLoc = new Point2D.Double(shooter.getX(), shooter.getY());
        double bulletSpeed = 20.0 - 3.0 * bulletPower;
        Point2D.Double futPos = new Point2D.Double(e.getX(), e.getY());
        int i = 0;
        while (i < 32) {
            long time = shooter.getTime() + (long)(myLoc.distance(futPos) / bulletSpeed);
            futPos = this.getFuturePos(time, e);
            ++i;
        }
        futPos.x = Util.limit(18.0, shooter.getBattleFieldWidth() - 18.0, futPos.x);
        futPos.y = Util.limit(18.0, shooter.getBattleFieldHeight() - 18.0, futPos.y);
        double absDeg = Util.absoluteBearing(myLoc, futPos);
        return absDeg;
    }

    public Point2D.Double getFuturePos(long when, AdvancedEnemyBot enemy) {
        double futX = enemy.getX();
        double futY = enemy.getY();
        double timeChange = when - enemy.lastUpdated;
        double change = enemy.heading - enemy.pHeading;
        if (Math.abs(change) > 1.0E-5) {
            double radius = (double)enemy.velocity / change;
            double totalHeadingChange = timeChange * change;
            futX = enemy.getX() + Math.cos(enemy.heading) * radius - Math.cos(enemy.heading + totalHeadingChange) * radius;
            futY = enemy.getY() + Math.sin(enemy.heading + totalHeadingChange) * radius - Math.sin(enemy.heading) * radius;
        } else {
            futX = enemy.getX() + Math.sin(enemy.heading) * (double)enemy.velocity * timeChange;
            futY = enemy.getY() + Math.cos(enemy.heading) * (double)enemy.velocity * timeChange;
        }
        return new Point2D.Double(futX, futY);
    }

    @Override
    public Color getColor() {
        return Color.white;
    }

    @Override
    public String getName() {
        return "Predictive Targeting Gun";
    }
}

