/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mue.BulletData;
import mue.RobotBase;
import mue.RobotData;
import mue.Util;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

class Knowledge {
    protected static final int INACTIVITY_TIME = 200;
    private Map robots = new HashMap(20);
    private RobotBase owner;
    private List bullets;
    private BulletData lastBullet;
    private long maxBulletTime;
    public long lastEnergyChange;

    public Knowledge(RobotBase robotBase) {
        this.owner = robotBase;
        this.lastEnergyChange = 0L;
        this.bullets = new LinkedList();
        this.lastBullet = null;
        this.maxBulletTime = (long)Math.ceil(Math.sqrt(this.owner.getBattleFieldWidth() * this.owner.getBattleFieldWidth() + this.owner.getBattleFieldHeight() * this.owner.getBattleFieldHeight()) / 11.0);
    }

    public void update(ScannedRobotEvent scannedRobotEvent) {
        BulletData bulletData;
        RobotData robotData = (RobotData)this.robots.get(scannedRobotEvent.getName());
        if (robotData == null) {
            robotData = new RobotData(this.owner, scannedRobotEvent.getName());
            this.robots.put(scannedRobotEvent.getName(), robotData);
        }
        if ((bulletData = robotData.update(scannedRobotEvent)) != null && !this.owner.isTeammate(robotData.getName())) {
            this.bullets.add(0, bulletData);
            this.lastBullet = bulletData;
        }
    }

    public void update(RobotDeathEvent robotDeathEvent) {
        BulletData bulletData;
        RobotData robotData = (RobotData)this.robots.get(robotDeathEvent.getName());
        if (robotData != null && (bulletData = robotData.update(robotDeathEvent)) != null && !this.owner.isTeammate(robotData.getName())) {
            this.bullets.add(0, bulletData);
            this.lastBullet = bulletData;
        }
    }

    public void update(BulletHitEvent bulletHitEvent) {
        BulletData bulletData;
        RobotData robotData = (RobotData)this.robots.get(bulletHitEvent.getName());
        if (robotData != null && (bulletData = robotData.update(bulletHitEvent)) != null && !this.owner.isTeammate(robotData.getName())) {
            this.bullets.add(0, bulletData);
            this.lastBullet = bulletData;
        }
    }

    public void update(HitByBulletEvent hitByBulletEvent) {
        RobotData robotData = (RobotData)this.robots.get(hitByBulletEvent.getName());
        if (robotData != null) {
            BulletData bulletData = this.getBullet(hitByBulletEvent.getBullet(), hitByBulletEvent.getTime());
            if (bulletData != null) {
                bulletData.deactivate();
            }
            if ((bulletData = robotData.update(hitByBulletEvent)) != null && !this.owner.isTeammate(robotData.getName())) {
                this.bullets.add(0, bulletData);
                this.lastBullet = bulletData;
            }
        }
    }

    public void update(BulletHitBulletEvent bulletHitBulletEvent) {
        BulletData bulletData = this.getBullet(bulletHitBulletEvent.getHitBullet(), bulletHitBulletEvent.getTime());
        if (bulletData != null) {
            bulletData.deactivate();
        }
    }

    public void update(HitRobotEvent hitRobotEvent) {
        BulletData bulletData;
        RobotData robotData = (RobotData)this.robots.get(hitRobotEvent.getName());
        if (robotData != null && (bulletData = robotData.update(hitRobotEvent)) != null && !this.owner.isTeammate(robotData.getName())) {
            this.bullets.add(0, bulletData);
            this.lastBullet = bulletData;
        }
    }

    public void updateEnergyChange(long l) {
        this.lastEnergyChange = l;
    }

    public boolean inactivityTimerExpired() {
        return this.owner.getTime() - this.lastEnergyChange > 200L;
    }

    public void removeRobot(String string) {
        this.robots.remove(string);
    }

    public RobotData getRobotData(String string) {
        return (RobotData)this.robots.get(string);
    }

    public RobotData getNearestEnemy() {
        Iterator iterator = this.robots.keySet().iterator();
        RobotData robotData = null;
        RobotData robotData2 = null;
        double d = 0.0;
        double d2 = this.owner.getX();
        double d3 = this.owner.getY();
        while (iterator.hasNext()) {
            robotData = (RobotData)this.robots.get(iterator.next());
            if (!robotData.isAlive() || this.owner.isTeammate(robotData.getName())) continue;
            double d4 = Util.squareDistance(d2, d3, robotData.getX(), robotData.getY());
            if (robotData2 != null && !(d4 < d)) continue;
            robotData2 = robotData;
            d = d4;
        }
        return robotData2;
    }

    public double getEnergyBalance() {
        Iterator iterator = this.robots.values().iterator();
        double d = this.owner.getEnergy();
        while (iterator.hasNext()) {
            RobotData robotData = (RobotData)iterator.next();
            d += this.owner.isTeammate(robotData.getName()) ? robotData.getEnergy() : -robotData.getEnergy();
        }
        return d;
    }

    public boolean isEmpty() {
        return this.robots.isEmpty();
    }

    public int numberOfRobots() {
        return this.robots.size();
    }

    public int numberOfEnemies() {
        Iterator iterator = this.robots.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RobotData robotData = (RobotData)this.robots.get(iterator.next());
            if (!robotData.isAlive() || this.owner.isTeammate(robotData.getName())) continue;
            ++n;
        }
        return n;
    }

    public BulletData lastBulletFired() {
        return this.lastBullet;
    }

    public BulletData nearestBullet() {
        if (this.bullets.isEmpty()) {
            return null;
        }
        Iterator iterator = this.bullets.iterator();
        BulletData bulletData = null;
        int n = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            int n2;
            BulletData bulletData2 = (BulletData)iterator.next();
            if (!bulletData2.isActive()) continue;
            if (this.owner.getTime() - bulletData2.getTime() > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            double d = Util.distance(this.owner.getX(), this.owner.getY(), bulletData2.getOriginX(), bulletData2.getOriginY());
            if (bulletData2.getSpeed() * (double)(this.owner.getTime() - bulletData2.getTime()) > d || (n2 = (int)Math.floor(d / bulletData2.getSpeed() - (double)(this.owner.getTime() - bulletData2.getTime() + 1L))) >= n) continue;
            n = n2;
            bulletData = bulletData2;
        }
        return bulletData;
    }

    public List activeBullets() {
        ArrayList<BulletData> arrayList = new ArrayList<BulletData>(this.bullets.size());
        Iterator iterator = this.bullets.iterator();
        while (iterator.hasNext()) {
            BulletData bulletData = (BulletData)iterator.next();
            if (this.owner.getTime() - bulletData.getTime() > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            if (!bulletData.isActive()) continue;
            arrayList.add(bulletData);
        }
        return arrayList;
    }

    public BulletData getBullet(Bullet bullet, long l) {
        Iterator iterator = this.bullets.iterator();
        while (iterator.hasNext()) {
            BulletData bulletData = (BulletData)iterator.next();
            if (this.owner.getTime() - bulletData.getTime() > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            if (Math.abs(bulletData.getPower() - bullet.getPower()) > 0.1) continue;
            double d = Util.distance(bulletData.getOriginX(), bulletData.getOriginY(), bullet.getX(), bullet.getY());
            double d2 = (double)(l - bulletData.getTime()) * bulletData.getSpeed() - d;
            if (!(d2 > -bulletData.getSpeed() - 1.0) || !(d2 < 2.0 * bulletData.getSpeed() + 1.0)) continue;
            return bulletData;
        }
        return null;
    }
}

