/*
 * Decompiled with CFR 0.152.
 */
package eem.radar;

import eem.bot.fighterBot;
import eem.misc.logger;
import eem.misc.math;
import java.util.LinkedList;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class radar {
    protected fighterBot myBot;
    protected int radarSpinDirection = 1;
    protected static double radarMaxRotationAngle;
    protected LinkedList<String> scannedBots = new LinkedList();
    protected String botToSearchFor = "";
    boolean needToTrackTarget = false;

    public radar(fighterBot fighterBot2) {
        this.initBattle(fighterBot2);
    }

    public void initBattle(fighterBot fighterBot2) {
        this.myBot = fighterBot2;
        radarMaxRotationAngle = 45.0;
        this.radarSpinDirection = 1;
        this.needToTrackTarget = false;
        this.botToSearchFor = "";
        this.scannedBots = new LinkedList();
    }

    public void initTic() {
        this.myBot.proxy.setAdjustRadarForGunTurn(true);
    }

    public void setNeedToTrackTarget(boolean bl) {
        this.needToTrackTarget = bl;
    }

    public void manage() {
        double d = 0.0;
        if (this.myBot.getNumEnemyAlive() == 0) {
            logger.noise("radar: no enemies left");
            return;
        }
        if (this.scannedBots.size() < this.myBot.getNumEnemyAlive()) {
            logger.noise("radar: sweeping battle field 1st time");
            d = (double)this.radarSpinDirection * radarMaxRotationAngle;
            this.setTurnRadarRight(d);
            return;
        }
        if (this.needToTrackTarget) {
            this.refreshBotsPositions();
            return;
        }
        this.refreshBotsPositions();
    }

    public void refreshBotsPositions() {
        logger.noise("radar: refreshBotsPositions");
        String string = this.scannedBots.getFirst();
        this.moveRadarToBot(string);
    }

    public void moveRadarToBot(String string) {
        logger.noise("Spinning radar to bot " + string);
        double d = 0.0;
        long l = this.myBot.getGameInfo().getTime() - this.myBot.getGameInfo()._botsmanager.getBotByName(string).getLastSeenTime();
        if (this.botToSearchFor.equals(string) && l > 1L) {
            d = (double)this.radarSpinDirection * radarMaxRotationAngle;
        } else {
            this.botToSearchFor = string;
            double d2 = this.myBot.proxy.getRadarHeading();
            double d3 = math.angle2pt(this.myBot.getPosition(), this.myBot.getGameInfo()._botsmanager.getBotByName(string).getPosition());
            d = d3 - d2;
            d = math.shortest_arc(d);
            this.radarSpinDirection = math.signNoZero(d);
            d = Math.abs(d);
            d += radarMaxRotationAngle / 2.0;
            d = (double)this.radarSpinDirection * d;
        }
        this.setTurnRadarRight(d);
    }

    protected void setTurnRadarRight(double d) {
        double d2 = math.putWithinRange(d, -radarMaxRotationAngle, radarMaxRotationAngle);
        logger.noise("radar: sweeping direction = " + this.radarSpinDirection);
        logger.noise("radar: rotation angle = " + d2);
        this.myBot.proxy.setTurnRadarRight(d2);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        String string = robotDeathEvent.getName();
        this.scannedBots.remove(string);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        String string = scannedRobotEvent.getName();
        for (String string2 : this.scannedBots) {
            if (!string2.equals(string)) continue;
            this.scannedBots.remove(string2);
            break;
        }
        this.scannedBots.addLast(string);
    }

    public String toString() {
        String string = "";
        string = string + "Radar stats\n";
        string = string + " bots known " + this.scannedBots.size() + " out of " + this.myBot.getNumEnemyAlive() + " alive\n";
        for (String string2 : this.scannedBots) {
            string = string + "  bot: " + string2 + "\n";
        }
        return string;
    }
}

