/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Angle;
import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bearing
implements Continuum<Bearing>,
AbsoluteToRelative<Bearing, Bearing> {
    private final Angle angle;

    public Bearing(Angle angle) {
        this.angle = angle.normalRelative();
    }

    @Override
    public Bearing negate() {
        return new Bearing(this.angle.negate());
    }

    @Override
    public Bearing abs() {
        return new Bearing(this.angle.abs());
    }

    @Override
    public Bearing plus(Bearing bearing) {
        return new Bearing(this.angle.plus(bearing.angle));
    }

    @Override
    public Bearing minus(Bearing bearing) {
        return new Bearing(this.angle.minus(bearing.angle));
    }

    @Override
    public Bearing times(double d) {
        return new Bearing(this.angle.times(d));
    }

    @Override
    public Bearing divide(double d) {
        return new Bearing(this.angle.divide(d));
    }

    @Override
    public double divide(Bearing bearing) {
        return this.angle.toDouble() / bearing.angle.toDouble();
    }

    public Angle toAngle() {
        return this.angle;
    }

    @Override
    public double toDouble() {
        return this.angle.toDouble();
    }

    public String toString() {
        return this.angle.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Bearing)) {
            return false;
        }
        Bearing bearing = (Bearing)o;
        return bearing.angle.equals(this.angle);
    }

    public int hashCode() {
        return this.angle.hashCode();
    }
}

