/*
 * Decompiled with CFR 0.152.
 */
package kenran.defense;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import kenran.Bakko;
import kenran.gfx.GfxUtils;
import kenran.util.FixedSizeQueue;
import kenran.util.Wave;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ShieldDash {
    private static final double WALL_STICK = 160.0;
    private static final int BINS = 47;
    private static final int MIDDLE_BIN = 23;
    private static final int DISTANCE_SEGMENT_COUNT = 3;
    private static final int ACCELERATION_SEGMENT_COUNT = 3;
    private static final double DISTANCE_KEEPING_ANGLE = 1.3707963267948966;
    private static final double[][][] _surfStats = new double[3][3][47];
    private final ArrayList<Wave> _enemyWaves = new ArrayList();
    private final FixedSizeQueue<Integer> _surfDirections = new FixedSizeQueue(3);
    private final FixedSizeQueue<Double> _surfAbsBearings = new FixedSizeQueue(3);
    private final Point2D.Double _enemyPosition = new Point2D.Double();
    private final Bakko _bakko;
    private double _enemyEnergy = 100.0;
    private double _lastVelocity = 0.0;
    private Wave _surfWave = null;

    public ShieldDash(Bakko bakko) {
        this._bakko = bakko;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyBearing = this._bakko.getHeadingRadians() + e.getBearingRadians();
        double lateralVelocity = this._bakko.getVelocity() * Math.sin(e.getBearingRadians());
        this._surfDirections.push(lateralVelocity >= 0.0 ? 1 : -1);
        this._surfAbsBearings.push(enemyBearing + Math.PI);
        double deltaEnergy = this._enemyEnergy - e.getEnergy();
        this._enemyEnergy = e.getEnergy();
        if (deltaEnergy <= 3.0 && deltaEnergy >= 0.1 && this._surfDirections.isFull()) {
            double bulletVelocity = Rules.getBulletSpeed((double)deltaEnergy);
            Wave w = new Wave();
            w.fireTime = this._bakko.getTime() - 1L;
            w.bulletVelocity = bulletVelocity;
            w.traveledDistance = bulletVelocity;
            w.direction = this._surfDirections.peek();
            w.angle = this._surfAbsBearings.peek();
            w.firePosition = (Point2D.Double)this._enemyPosition.clone();
            w.distanceSegment = this.distanceSegment(e.getDistance());
            w.accelerationSegment = this.accelerationSegment();
            this._enemyWaves.add(w);
        }
        this._enemyPosition.setLocation(this._bakko.getEnemyPosition());
        this._lastVelocity = this._bakko.getVelocity();
        this.updateWaves();
        this.surf();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bullet bullet = e.getBullet();
        this._enemyEnergy += 3.0 * bullet.getPower();
        if (this._enemyWaves.isEmpty()) {
            return;
        }
        Point2D.Double hitPosition = new Point2D.Double(bullet.getX(), bullet.getY());
        Wave hitWave = null;
        for (Wave wave : this._enemyWaves) {
            if (!(Math.abs(wave.traveledDistance - this._bakko.getPosition().distance(wave.firePosition)) < 50.0) || Math.round(Rules.getBulletSpeed((double)e.getBullet().getPower()) * 10.0) != Math.round(wave.bulletVelocity * 10.0)) continue;
            hitWave = wave;
            break;
        }
        if (hitWave != null) {
            this.logHit(hitWave, hitPosition);
            this._enemyWaves.remove(hitWave);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (this._enemyWaves.isEmpty()) {
            return;
        }
        Point2D.Double hitPosition = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        Wave hitWave = null;
        for (Wave wave : this._enemyWaves) {
            if (!(Math.abs(wave.traveledDistance - wave.firePosition.distance(hitPosition)) < 50.0) || Math.round(Rules.getBulletSpeed((double)e.getHitBullet().getPower()) * 10.0) != Math.round(wave.bulletVelocity * 10.0)) continue;
            hitWave = wave;
            break;
        }
        if (hitWave != null) {
            this.logHit(hitWave, hitPosition);
            this._enemyWaves.remove(hitWave);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this._enemyEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    private int distanceSegment(double distance) {
        if (distance <= 300.0) {
            return 0;
        }
        if (distance <= 600.0) {
            return 1;
        }
        return 2;
    }

    private int accelerationSegment() {
        double velocityDifference = this._bakko.getVelocity() - this._lastVelocity;
        if (velocityDifference == 0.0) {
            return 1;
        }
        return velocityDifference < 0.0 ? 0 : 2;
    }

    private void updateWaves() {
        for (int i = 0; i < this._enemyWaves.size(); ++i) {
            Wave w = this._enemyWaves.get(i);
            w.traveledDistance = (double)(this._bakko.getTime() - w.fireTime) * w.bulletVelocity;
            if (!(w.traveledDistance > this._bakko.getPosition().distance(w.firePosition) + 50.0)) continue;
            this._enemyWaves.remove(i);
            --i;
        }
    }

    private Wave getClosestSurfableWave() {
        double minimumDistance = Double.POSITIVE_INFINITY;
        Wave surfWave = null;
        for (Wave wave : this._enemyWaves) {
            double distance = this._bakko.getPosition().distance(wave.firePosition) - wave.traveledDistance;
            if (!(distance > wave.bulletVelocity) || !(distance < minimumDistance)) continue;
            surfWave = wave;
            minimumDistance = distance;
        }
        return surfWave;
    }

    private static int getFactorIndex(Wave wave, Point2D.Double position) {
        double d1 = kenran.util.Utils.absoluteBearing(wave.firePosition, position) - wave.angle;
        double d2 = Utils.normalRelativeAngle((double)d1) / kenran.util.Utils.maxEscapeAngle(wave.bulletVelocity) * (double)wave.direction;
        return (int)kenran.util.Utils.limit(0.0, d2 * 23.0 + 23.0, 46.0);
    }

    private void logHit(Wave wave, Point2D.Double position) {
        int i = ShieldDash.getFactorIndex(wave, position);
        for (int j = 0; j < 47; ++j) {
            double[] dArray = _surfStats[wave.distanceSegment][wave.accelerationSegment];
            int n = j;
            dArray[n] = dArray[n] + 1.0 / (Math.pow(i - j, 2.0) + 1.0);
        }
    }

    private Point2D.Double predictPosition(Wave wave, int direction) {
        Point2D.Double impactPosition = (Point2D.Double)this._bakko.getPosition().clone();
        double velocity = this._bakko.getVelocity();
        double heading = this._bakko.getHeadingRadians();
        int turnCount = 0;
        boolean intercepted = false;
        do {
            double unsmoothedAngle = kenran.util.Utils.absoluteBearing(wave.firePosition, impactPosition) + (double)direction * 1.3707963267948966;
            double goAngle = kenran.util.Utils.wallSmoothing(this._bakko.getBattleField(), impactPosition, unsmoothedAngle, direction, 160.0) - heading;
            double goDirection = 1.0;
            if (Math.cos(goAngle) < 0.0) {
                goAngle += Math.PI;
                goDirection = -1.0;
            }
            goAngle = Utils.normalRelativeAngle((double)goAngle);
            double maxTurnRate = Rules.getTurnRateRadians((double)velocity);
            heading = Utils.normalRelativeAngle((double)(heading + kenran.util.Utils.limit(-maxTurnRate, goAngle, maxTurnRate)));
            velocity += velocity * goDirection < 0.0 ? 2.0 * goDirection : goDirection;
            velocity = kenran.util.Utils.limit(-8.0, velocity, 8.0);
            impactPosition = kenran.util.Utils.project(impactPosition, heading, velocity);
            ++turnCount;
            if (!(impactPosition.distance(wave.firePosition) < wave.traveledDistance + (double)turnCount * wave.bulletVelocity + wave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && turnCount < 500);
        return impactPosition;
    }

    private double checkDanger(Wave wave, int direction) {
        int i = ShieldDash.getFactorIndex(wave, this.predictPosition(wave, direction));
        return _surfStats[wave.distanceSegment][wave.accelerationSegment][i];
    }

    private void surf() {
        this._surfWave = this.getClosestSurfableWave();
        if (this._surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(this._surfWave, -1);
        double dangerRight = this.checkDanger(this._surfWave, 1);
        double angle = kenran.util.Utils.absoluteBearing(this._surfWave.firePosition, this._bakko.getPosition());
        int orientation = dangerLeft < dangerRight ? -1 : 1;
        angle = kenran.util.Utils.wallSmoothing(this._bakko.getBattleField(), this._bakko.getPosition(), angle + (double)orientation * 1.3707963267948966, orientation, 160.0);
        kenran.util.Utils.setBackAsFront(this._bakko, angle);
    }

    public void onPaint(Graphics2D g) {
        for (Wave w : this._enemyWaves) {
            if (w == this._surfWave) {
                g.setColor(Color.ORANGE);
            } else {
                g.setColor(Color.GRAY);
            }
            GfxUtils.drawCircle(g, w.firePosition, w.traveledDistance);
        }
    }
}

