/*
 * Decompiled with CFR 0.152.
 */
package dk.move;

import dk.Base;
import dk.BattleField;
import dk.Enemy;
import dk.Point;
import dk.Util;
import dk.Vector;
import dk.move.MagneticSourceController;
import dk.move.Movement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import robocode.Robot;

public class Magnetic
extends Movement {
    public static boolean debug = false;
    protected List sourceControllers = new ArrayList();

    public List getSourceControllers() {
        return this.sourceControllers;
    }

    public void addSourceController(MagneticSourceController controller) {
        this.sourceControllers.add(controller);
    }

    public Vector sumVectors(Point robotPosition, Vector v, List sources) {
        if (sources != null) {
            Iterator i = sources.iterator();
            while (i.hasNext()) {
                Source s = (Source)i.next();
                if (s.getPosition() == null) continue;
                Vector repulsion = new Vector(Util.bearing(robotPosition, s.getPosition()), s.getStrength(Util.range(robotPosition, s.getPosition())));
                if (debug) {
                    BattleField.println(" r = " + repulsion);
                }
                v = v.add(repulsion);
            }
        }
        return v;
    }

    public Vector getNewMovementVector(Base robot) {
        Vector v = robot.getMovementVector();
        Point robotPosition = robot.getPosition();
        if (debug) {
            BattleField.println("v = " + v);
        }
        Iterator sourceIterator = this.sourceControllers.iterator();
        while (sourceIterator.hasNext()) {
            MagneticSourceController controller = (MagneticSourceController)sourceIterator.next();
            v = this.sumVectors(robotPosition, v, controller.getMagneticSources(robot));
        }
        if (debug) {
            BattleField.println("newV = " + v);
        }
        return v;
    }

    public void setMovement(Base robot) {
        Vector v = this.getNewMovementVector(robot);
        Vector r = robot.getMovementVector();
        this.applyMovement(robot, r, v);
    }

    public void applyMovement(Base robot, Vector r, Vector v) {
        double angle = v.getAngle() - r.getAngle();
        double distance = v.getMagnitude() - r.getMagnitude();
        angle = Util.normalizeBearing(angle);
        if (robot.config.MAGNETIC_REVERSE && Math.abs(angle) > 1.5707963267948966) {
            if (debug) {
                ((Robot)robot).out.println("considering reverse " + Util.toDegrees(Math.abs(angle)));
            }
            if (r.getMagnitude() < 0.0 && distance > 2.0) {
                distance = -distance;
                if (angle > 1.5707963267948966) {
                    angle = -(Math.PI - angle);
                } else if (angle < -1.5707963267948966) {
                    angle = -(-1.5707963267948966 - angle);
                }
            }
        }
        double maxVelocity = 8.0;
        if (Math.abs(angle) > robot.config.MAGNETIC_TURN_THRESHOLD) {
            maxVelocity = 8.0 - (Math.abs(angle) - robot.config.MAGNETIC_TURN_THRESHOLD) / Math.PI * robot.config.MAGNETIC_TURN_FACTOR;
        }
        if (Math.abs(distance) < robot.config.MAGNETIC_MIN_MOVE) {
            distance = distance < 0.0 ? -robot.config.MAGNETIC_MIN_MOVE : robot.config.MAGNETIC_MIN_MOVE;
        }
        if (debug) {
            ((Robot)robot).out.println("turn = " + Util.toDegrees(angle) + " facing = " + Util.toDegrees(r.getAngle()));
            ((Robot)robot).out.println("maxV = " + maxVelocity);
            ((Robot)robot).out.println("drive = " + distance);
        }
        this.setMovement(robot, distance, maxVelocity, angle);
    }

    public void setMovement(Base robot, double distance, double maxVelocity, double angle) {
        robot.setMaxVelocity(Math.max(0.0, maxVelocity));
        if (angle < 0.0) {
            robot.setTurnLeftRadians(-angle);
        } else {
            robot.setTurnRightRadians(angle);
        }
        if (distance < 0.0) {
            robot.setBack(-distance);
        } else {
            robot.setAhead(distance);
        }
    }

    public void onEnemyBulletFired(Base robot, Enemy e, double power) {
        Iterator iter = this.sourceControllers.iterator();
        while (iter.hasNext()) {
            MagneticSourceController s = (MagneticSourceController)iter.next();
            s.onEnemyBulletFired(robot, e, power);
        }
    }

    public static interface Source {
        public Point getPosition();

        public double getStrength(double var1);
    }

    public static class StaticSource
    implements Source {
        protected Point p_;
        protected double strength_;

        public StaticSource(Point p, double strength) {
            this.p_ = p;
            this.strength_ = strength;
        }

        public Point getPosition() {
            return this.p_;
        }

        public double getStrength(double d) {
            return this.strength_;
        }
    }

    public static class EyeStaticSource
    extends StaticSource {
        protected double size_;

        public EyeStaticSource(Point p, double strength, double size) {
            super(p, strength);
            this.size_ = size;
        }

        public double getStrength(double d) {
            if ((d -= this.size_) < 1.0) {
                return 0.0;
            }
            return super.getStrength(d);
        }
    }

    public static class ExponentialSource
    extends StaticSource {
        protected double power_;

        public ExponentialSource(Point p, double strength, double power) {
            super(p, strength);
            this.power_ = power;
        }

        public double getStrength(double d) {
            if (d < 1.0) {
                d = 1.0;
            }
            return this.strength_ / Math.pow(d, this.power_);
        }
    }

    public static class LinearSource
    extends StaticSource {
        public LinearSource(Point p, double strength) {
            super(p, strength);
        }

        public double getStrength(double d) {
            if (d < 1.0) {
                d = 1.0;
            }
            return this.strength_ / d;
        }
    }

    public static class LargeLinearSource
    extends LinearSource {
        protected double size_;

        public LargeLinearSource(Point p, double strength, double size) {
            super(p, strength);
            this.size_ = size;
        }

        public double getStrength(double d) {
            if ((d -= this.size_) < 1.0) {
                d = 1.0;
            }
            return super.getStrength(d);
        }
    }

    public static class EyeLinearSource
    extends LinearSource {
        protected double size_;

        public EyeLinearSource(Point p, double strength, double size) {
            super(p, strength);
            this.size_ = size;
        }

        public double getStrength(double d) {
            if ((d -= this.size_) < 1.0) {
                return 0.0;
            }
            return super.getStrength(d);
        }
    }

    public static class InverseSource
    extends StaticSource {
        public InverseSource(Point p, double strength) {
            super(p, strength);
        }

        public double getStrength(double d) {
            return this.strength_ * d;
        }
    }

    public static class SquareSource
    extends StaticSource {
        public SquareSource(Point p, double strength) {
            super(p, strength);
        }

        public double getStrength(double d) {
            if (d < 1.0) {
                d = 1.0;
            }
            return this.strength_ / (d * d);
        }
    }
}

