/*
 * Decompiled with CFR 0.152.
 */
package dk.predict.buckets;

import dk.Enemy;
import dk.Histogram;
import dk.Util;
import dk.predict.Buckets;
import dk.predict.Factors;
import java.io.PrintStream;
import java.util.List;

public class BucketsRVAO
extends Buckets {
    protected int rangeBuckets = 8;
    protected int velocityBuckets = 5;
    protected int accelerationBuckets = 3;
    protected int timeSinceDirectionChangeBuckets = 4;
    protected double maxRange = 1000.0;
    protected double maxVelocity = 8.0;
    protected double maxAcceleration = 1.0;
    protected double maxTimeSinceDirectionChange = 20.0;
    protected Histogram[][][][] buckets;

    public BucketsRVAO(Enemy enemy, List predictorFactories) {
        super(enemy, predictorFactories);
        this.setupBuckets(predictorFactories);
    }

    public static Buckets.Factory factory() {
        return new Buckets.Factory(){

            public Buckets newInstance(Enemy enemy, List predictorFactories) {
                return new BucketsRVAO(enemy, predictorFactories);
            }
        };
    }

    protected void setupBuckets(List predictorFactories) {
        this.buckets = new Histogram[this.rangeBuckets][this.velocityBuckets][this.accelerationBuckets][this.timeSinceDirectionChangeBuckets];
        int r = 0;
        while (r < this.rangeBuckets) {
            int v = 0;
            while (v < this.velocityBuckets) {
                int a = 0;
                while (a < this.accelerationBuckets) {
                    int td = 0;
                    while (td < this.timeSinceDirectionChangeBuckets) {
                        this.buckets[r][v][a][td] = this.createHistogram(predictorFactories);
                        String name = "bucket r < " + Util.valueFromIndex(r, this.rangeBuckets, 0.0, this.maxRange) + " v < " + Util.valueFromIndex(v, this.velocityBuckets, -this.maxVelocity, this.maxVelocity) + " a < " + Util.valueFromIndex(a, this.accelerationBuckets, -this.maxAcceleration, this.maxAcceleration) + " td < " + Util.valueFromIndex(td, this.timeSinceDirectionChangeBuckets, 0.0, this.maxTimeSinceDirectionChange);
                        this.buckets[r][v][a][td].setName(name);
                        ++td;
                    }
                    ++a;
                }
                ++v;
            }
            ++r;
        }
    }

    public Histogram getHistogram(Factors f) {
        int r = Util.indexFromValue(f.getDistance(), this.rangeBuckets, 0.0, this.maxRange);
        int v = Util.indexFromValue(f.getVelocity(), this.velocityBuckets, -this.maxVelocity, this.maxVelocity);
        int a = Util.indexFromValue(f.getAcceleration(), this.accelerationBuckets, -this.maxAcceleration, this.maxAcceleration);
        int td = Util.indexFromValue(f.getTimeSinceLastDirectionChange(), this.timeSinceDirectionChangeBuckets, 0.0, this.maxTimeSinceDirectionChange);
        return this.buckets[r][v][a][td];
    }

    public void printStats(PrintStream out) {
        super.printStats(out);
        int r = 0;
        while (r < this.rangeBuckets) {
            int v = 0;
            while (v < this.velocityBuckets) {
                int a = 0;
                while (a < this.accelerationBuckets) {
                    int td = 0;
                    while (td < this.timeSinceDirectionChangeBuckets) {
                        this.buckets[r][v][a][td].printStats(out);
                        ++td;
                    }
                    ++a;
                }
                ++v;
            }
            ++r;
        }
    }
}

