/*
 * Decompiled with CFR 0.152.
 */
package dk.tactics;

import dk.Base;
import dk.Enemy;
import dk.tactics.Tactics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public abstract class Aggregate
extends Tactics {
    protected List tactics = new ArrayList();

    public void addTactic(Tactics t) {
        this.tactics.add(t);
    }

    public void clearTactics() {
        this.tactics.clear();
    }

    public void doTurn(Base robot) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.doTurn(robot);
        }
    }

    public void doStartRound(Base robot) {
        super.doStartRound(robot);
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.doStartRound(robot);
        }
    }

    public void onDeath(Base robot, DeathEvent e) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onDeath(robot, e);
        }
    }

    public void onHitByBullet(Base robot, HitByBulletEvent e) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onHitByBullet(robot, e);
        }
    }

    public void onRobotDeath(Base robot, RobotDeathEvent e) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onRobotDeath(robot, e);
        }
    }

    public void onScannedRobot(Base robot, ScannedRobotEvent e) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onScannedRobot(robot, e);
        }
    }

    public void onWin(Base robot, WinEvent e) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onWin(robot, e);
        }
    }

    public void onHitRobot(Base robot, HitRobotEvent e) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onHitRobot(robot, e);
        }
    }

    public void onEnemyBulletFired(Base robot, Enemy e, double power) {
        Iterator iter = this.tactics.iterator();
        while (iter.hasNext()) {
            Tactics t = (Tactics)iter.next();
            t.onEnemyBulletFired(robot, e, power);
        }
    }
}

