/*
 * Decompiled with CFR 0.152.
 */
package simonton.core;

import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import simonton.core.Bot;
import simonton.core.SlaveBot;
import simonton.core.Synchronizer;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;

public class EnemySynchronizer
extends Synchronizer {
    private BulletHitEvent hit;
    private BulletHitBulletEvent cross;
    private HitByBulletEvent burn;
    private ScannedRobotEvent scan;
    private WinEvent imMelting;
    private HitRobotEvent slam;
    private HitRobotEvent slammed;
    private HitWallEvent bang;
    private double expectedEnergy;
    private double lastAccelleration;
    private boolean dead;

    public EnemySynchronizer(Bot master, SlaveBot slave) {
        super(master, slave);
    }

    @Override
    public void run() {
        super.run();
        this.expectedEnergy = 100.0;
        this.slave.setGunHeat(3.0);
        this.dead = false;
    }

    @Override
    public void runIteration() {
        if (this.dead) {
            return;
        }
        this.slave.fire = false;
        this.slave.setTime(this.master.getTime());
        double firePower = 0.0;
        if (this.scan != null) {
            firePower = this.expectedEnergy - this.scan.getEnergy();
            double accelleration = this.slave.getVelocity() - this.scan.getVelocity();
            if (firePower > 0.0 && this.scan.getVelocity() == 0.0 && (this.slave.getGunHeat() > 1.0E-5 || firePower > 3.0)) {
                this.bang = new HitWallEvent(0.0);
                double min = Util.getWallHitDamage(FastMath.max(FastMath.abs(accelleration) - 2.0, 0.0));
                double max = Util.getWallHitDamage(FastMath.min(FastMath.abs(accelleration) + 1.0, 8.0));
                firePower = min <= firePower && max >= firePower ? 0.0 : FastMath.max(firePower - Util.getWallHitDamage(FastMath.bound(FastMath.abs(accelleration - this.lastAccelleration), 0.0, 8.0)), 0.0);
            }
            this.lastAccelleration = accelleration;
            this.expectedEnergy = this.scan.getEnergy();
            if (this.expectedEnergy == 0.0 && firePower > 0.0 && firePower < 0.1) {
                firePower = 0.1;
            }
            Location slaveLoc = new Location(this.master, this.scan);
            this.slave.setX(slaveLoc.x);
            this.slave.setY(slaveLoc.y);
            this.slave.setVelocity(this.scan.getVelocity());
            this.slave.setHeadingRadians(this.scan.getHeadingRadians());
            this.slave.setEnergy(this.expectedEnergy);
        } else if (this.imMelting != null && this.slave.getEnergy() > 0.0 && this.slave.getGunHeat() < 1.0E-5) {
            firePower = FastMath.min(this.slave.firePower, this.slave.getEnergy());
        }
        if (firePower < 3.00001 && firePower > 0.09999000000000001) {
            this.slave.setGunHeat(Util.getGunHeat(firePower));
            this.slave.firePower = firePower;
            this.slave.fire = true;
        }
        if ((double)Util.time < 3.0 / Util.gunCoolingRate) {
            this.slave.setGunHeat(3.0 - (double)Util.time * Util.gunCoolingRate);
        } else {
            this.slave.setGunHeat(FastMath.max(0.0, this.slave.getGunHeat() - Util.gunCoolingRate));
        }
        this.slave.doCustomEvents();
        if (this.imMelting != null) {
            this.slave.onDeath(new DeathEvent());
            this.imMelting = null;
            this.dead = true;
        }
        if (this.cross != null) {
            Bullet bullet = this.cross.getHitBullet();
            Bullet hitBullet = this.cross.getBullet();
            BulletHitBulletEvent flipCross = new BulletHitBulletEvent(bullet, hitBullet);
            this.slave.onBulletHitBullet(flipCross);
            this.cross = null;
        }
        if (this.burn != null) {
            String name = this.master.getName();
            double energy = this.master.getEnergy();
            Bullet bullet = this.burn.getBullet();
            this.slave.onBulletHit(new BulletHitEvent(name, energy, bullet));
            this.burn = null;
        }
        if (this.slam != null) {
            this.doFlipped(this.slam);
            this.slam = null;
        }
        if (this.slammed != null) {
            this.doFlipped(this.slammed);
            this.slammed = null;
        }
        if (this.bang != null) {
            this.slave.onHitWall(this.bang);
            this.bang = null;
        }
        if (this.hit != null) {
            Bullet bullet = this.hit.getBullet();
            double flipHeading = FastMath.normalize(bullet.getHeadingRadians() + Math.PI - this.slave.getHeading());
            this.slave.onHitByBullet(new HitByBulletEvent(flipHeading, bullet));
            this.hit = null;
        }
        if (this.scan != null) {
            double flipBearing = Util.getAbsoluteBearing(this.master, this.scan) + Math.PI;
            this.slave.onScannedRobot(new ScannedRobotEvent(this.master.getName(), this.master.getEnergy(), FastMath.normalize(flipBearing - this.slave.getHeadingRadians()), this.scan.getDistance(), this.master.getHeadingRadians(), this.master.getVelocity()));
            this.scan = null;
        }
        this.slave.runIteration();
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        this.expectedEnergy = FastMath.max(0.0, this.expectedEnergy - Util.getBulletDamage(e.getBullet().getPower()));
        this.hit = e;
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.cross = e;
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        this.expectedEnergy += Util.getBulletHitBonus(e.getPower());
        this.burn = e;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.scan = e;
    }

    @Override
    public void onRobodDeath(RobotDeathEvent robotdeathevent) {
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        this.expectedEnergy -= 0.6;
        if (e.isMyFault()) {
            this.slam = e;
        } else {
            this.slammed = e;
        }
    }

    @Override
    public void onBulletMissed(BulletMissedEvent bulletmissedevent) {
    }

    @Override
    public void onDeath(DeathEvent deathevent) {
    }

    @Override
    public void onHitWall(HitWallEvent hitwallevent) {
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent skippedturnevent) {
    }

    @Override
    public void onWin(WinEvent e) {
        this.imMelting = e;
    }

    private void doFlipped(HitRobotEvent slam) {
        double bearing = this.master.getHeadingRadians() + slam.getBearing();
        bearing = FastMath.normalize(bearing + Math.PI - this.slave.getHeadingRadians());
        this.slave.onHitRobot(new HitRobotEvent(this.master.getName(), bearing, this.master.getEnergy(), !slam.isMyFault()));
    }
}

