/*
 * Decompiled with CFR 0.152.
 */
package simonton.utils;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import simonton.core.Bot;
import simonton.guns.Gun;
import simonton.utils.FastMath;
import simonton.utils.Location;

public class Util {
    public static final double WALL_MARGIN = 18.0;
    public static final double S = 18.0;
    public static final double W = 18.0;
    public static double N;
    public static double E;
    public static Point2D.Double centerPoint;
    public static Rectangle2D.Double botBounds;
    public static double worldWidth;
    public static double worldHeight;
    public static double maxDistance;
    public static double minDistance;
    public static double gunCoolingRate;
    public static int roundNum;
    public static int numRounds;
    public static int time;
    public static int NORTH;
    public static int SOUTH;
    public static int EAST;
    public static int WEST;

    static {
        minDistance = 36.0;
        NORTH = 1;
        SOUTH = 2;
        EAST = 4;
        WEST = 8;
    }

    public static void startRound(AdvancedRobot robot) {
        worldWidth = robot.getBattleFieldWidth();
        worldHeight = robot.getBattleFieldHeight();
        gunCoolingRate = robot.getGunCoolingRate();
        N = worldHeight - 18.0;
        E = worldWidth - 18.0;
        botBounds = new Rectangle2D.Double(18.0, 18.0, worldWidth - 36.0 + 1.0E-10, worldHeight - 36.0 + 1.0E-10);
        centerPoint = new Point2D.Double(worldWidth / 2.0, worldHeight / 2.0);
        maxDistance = FastMath.sqrt(FastMath.square(worldHeight - 36.0) + FastMath.square(worldWidth - 36.0));
        numRounds = robot.getNumRounds();
        roundNum = robot.getRoundNum();
    }

    public static void startTurn(Bot bot) {
        time = (int)bot.getTime();
    }

    public static void endBattle() {
    }

    public static void log(String message, Object[] formatArgs) {
        message = String.format("%d: %s%n", time, String.format(message, formatArgs));
        System.out.print(message);
    }

    public static double bearing(Point2D.Double p1, Point2D.Double p2) {
        return FastMath.atan2(p2.x - p1.x, p2.y - p1.y);
    }

    public static int bearingDegs(Point2D.Double p1, Point2D.Double p2) {
        return (int)(FastMath.toDegrees(Util.bearing(p1, p2)) + 0.5);
    }

    public static Location project(Point2D.Double location, double distance, int angle) {
        return new Location(location.x + distance * FastMath.sin(angle), location.y + distance * FastMath.cos(angle));
    }

    public static Location project(Point2D.Double location, double distance, double angle) {
        return new Location(location.x + distance * FastMath.sin(angle), location.y + distance * FastMath.cos(angle));
    }

    public static Location project(Bot bot, ScannedRobotEvent scan) {
        return Util.project(new Point2D.Double(bot.getX(), bot.getY()), scan.getDistance(), scan.getBearingRadians() + bot.getHeadingRadians());
    }

    public static boolean inBound(Point2D.Double p, double margin) {
        boolean mod = false;
        double bound = margin;
        if (p.x < bound) {
            p.x = bound;
            mod = true;
        } else {
            bound = worldWidth - margin;
            if (p.x > bound) {
                p.x = bound;
                mod = true;
            }
        }
        bound = margin;
        if (p.y < bound) {
            p.y = bound;
            mod = true;
        } else {
            bound = worldHeight - margin;
            if (p.y > bound) {
                p.y = bound;
                mod = true;
            }
        }
        return mod;
    }

    public static boolean inBound(Point2D.Double p, double margin, double angle) {
        boolean mod = false;
        double bound = margin;
        if (p.x < bound) {
            p.y += (bound - p.x) * FastMath.tan(4.71238898038469 - angle);
            p.x = bound;
            mod = true;
        } else {
            bound = worldWidth - margin;
            if (p.x > bound) {
                p.y += (p.x - bound) * FastMath.tan(angle - 1.5707963267948966);
                p.x = bound;
                mod = true;
            }
        }
        bound = margin;
        if (p.y < bound) {
            p.x += (bound - p.y) * FastMath.tan(angle - Math.PI);
            p.y = bound;
            mod = true;
        } else {
            bound = worldHeight - margin;
            if (p.y > bound) {
                p.x += (p.y - bound) * FastMath.tan(-angle);
                p.y = bound;
                mod = true;
            }
        }
        return mod;
    }

    public static int outcode(Point2D.Double p, double margin) {
        int outcode = 0;
        if (p.x < margin) {
            outcode = WEST;
        } else if (p.x >= worldWidth - margin) {
            outcode = EAST;
        }
        if (p.y < margin) {
            return outcode | SOUTH;
        }
        if (p.y >= worldHeight - margin) {
            return outcode | NORTH;
        }
        return outcode;
    }

    public static double wallDistance(Point2D.Double p, int h, double v) {
        double west;
        if (v < 0.0) {
            h += 180;
        }
        h = FastMath.cannonize(h);
        double distance = Double.POSITIVE_INFINITY;
        if (h < 90 || h > 270) {
            distance = (worldHeight - p.y) / FastMath.cos[h];
        } else if (h > 90 && h < 270) {
            distance = p.y / -FastMath.cos[h];
        }
        if (h < 180) {
            double east = (worldWidth - p.x) / FastMath.sin[h];
            if (east < distance) {
                distance = east;
            }
        } else if (h > 180 && (west = p.x / -FastMath.sin[h]) < distance) {
            distance = west;
        }
        return distance;
    }

    public static double wallDistance(int oDir, Bot bot, ScannedRobotEvent e) {
        double x = bot.getX();
        double y = bot.getY();
        double eDist = e.getDistance();
        double eAngle = Util.getAbsoluteBearing(bot, e);
        return Util.wallDistance(oDir, x, y, eDist, eAngle);
    }

    public static double wallDistance(int oDir, double x, double y, double eDist, double eAngle) {
        double wallDistance = Util.distanceWest(N - y, eDist, eAngle - 1.5707963267948966, oDir);
        double testDistance = Util.distanceWest(E - x, eDist, eAngle + Math.PI, oDir);
        if (testDistance < wallDistance) {
            wallDistance = testDistance;
        }
        if ((testDistance = Util.distanceWest(y - 18.0, eDist, eAngle + 1.5707963267948966, oDir)) < wallDistance) {
            wallDistance = testDistance;
        }
        if ((testDistance = Util.distanceWest(x - 18.0, eDist, eAngle, oDir)) < wallDistance) {
            wallDistance = testDistance;
        }
        return wallDistance;
    }

    public static double wallAngle(int oDir, Bot bot, ScannedRobotEvent e) {
        double x = bot.getX();
        double y = bot.getY();
        double eDist = e.getDistance();
        double eAngle = Util.getAbsoluteBearing(bot, e);
        double wallDistance = Util.distanceWest(N - y, eDist, eAngle - 1.5707963267948966, oDir);
        int closestWall = 78;
        double testDistance = Util.distanceWest(E - x, eDist, eAngle + Math.PI, oDir);
        if (testDistance < wallDistance) {
            wallDistance = testDistance;
            closestWall = 69;
        }
        if ((testDistance = Util.distanceWest(y - 18.0, eDist, eAngle + 1.5707963267948966, oDir)) < wallDistance) {
            wallDistance = testDistance;
            closestWall = 83;
        }
        if ((testDistance = Util.distanceWest(x - 18.0, eDist, eAngle, oDir)) < wallDistance) {
            wallDistance = testDistance;
            closestWall = 87;
        }
        double wallAngle = FastMath.cannonize(Utils.normalNearAbsoluteAngle((double)(eAngle + (double)oDir * wallDistance)));
        if (closestWall == 78) {
            if (oDir == 1) {
                return wallAngle - 4.71238898038469;
            }
            return 1.5707963267948966 - wallAngle;
        }
        if (closestWall == 83) {
            if (oDir == 1) {
                return wallAngle - 1.5707963267948966;
            }
            return 4.71238898038469 - wallAngle;
        }
        if (closestWall == 69) {
            if (oDir == 1) {
                return wallAngle;
            }
            return Math.PI - wallAngle;
        }
        if (oDir == 1) {
            return wallAngle - Math.PI;
        }
        return Math.PI * 2 - wallAngle;
    }

    public static double distanceWest(double toWall, double eDist, double eAngle, int oDir) {
        if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
        }
        double wallAngle = FastMath.acos((double)(-oDir) * toWall / eDist) + (double)oDir * 1.5707963267948966;
        return FastMath.cannonize((double)oDir * (wallAngle - eAngle));
    }

    public static double predictEnergy(Gun gun, int time) {
        throw new Error("Unresolved compilation problems: \n\tThe method getNextBulletPower() is undefined for the type Gun\n\tThe method getNextBulletPower() is undefined for the type Gun\n");
    }

    public static double getBulletSpeed(double power) {
        return 20.0 - 3.0 * FastMath.bound(power, 0.1, 3.0);
    }

    public static double getBulletDamage(double power) {
        if (power > 1.0) {
            return 6.0 * power - 2.0;
        }
        return 4.0 * power;
    }

    public static double getBulletHitBonus(double power) {
        return 3.0 * power;
    }

    public static double getWallHitDamage(double hitVelocity) {
        return FastMath.max(FastMath.abs(hitVelocity) / 2.0 - 1.0, 0.0);
    }

    public static double getTurnRateRadians(double speed) {
        return 0.17453292519943295 - 0.01308996938995747 * FastMath.abs(speed);
    }

    public static double getMaxEscape(double bulletSpeed) {
        return FastMath.asin(8.0 / bulletSpeed);
    }

    public static double getGunHeat(double power) {
        return 1.0 + power / 5.0;
    }

    public static double getAbsoluteBearing(Bot bot, ScannedRobotEvent e) {
        return bot.getHeadingRadians() + e.getBearingRadians();
    }

    public static double getRelativeHeading(Bot bot, ScannedRobotEvent e) {
        return e.getHeadingRadians() - Util.getAbsoluteBearing(bot, e);
    }

    public static double getLateralVelocity(Bot bot, ScannedRobotEvent e) {
        return e.getVelocity() * FastMath.sin(Util.getRelativeHeading(bot, e));
    }

    public static double getRetreatingVelocity(Bot bot, ScannedRobotEvent e) {
        return e.getVelocity() * FastMath.cos(Util.getRelativeHeading(bot, e));
    }

    public static double getMyLateralVelocity(Bot bot, ScannedRobotEvent e) {
        return bot.getVelocity() * FastMath.sin(e.getBearingRadians());
    }

    public static double[] copyOf(double[] array) {
        double[] copy = new double[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static boolean equal(Point2D.Double p1, Point2D.Double p2) {
        return FastMath.equal(p1.x, p2.x) && FastMath.equal(p1.y, p2.y);
    }

    public static void paintLine(Graphics2D g, Point2D.Double p1, Point2D.Double p2) {
        g.drawLine((int)Math.round(p1.x), (int)Math.round(p1.y), (int)Math.round(p2.x), (int)Math.round(p2.y));
    }

    public static void paintLine(Graphics2D g, Point2D.Double source, double angle) {
        Util.paintLine(g, source, Util.project(source, 1000.0, angle));
    }

    public static void paintCircle(Graphics2D g, Point2D.Double p, double width, boolean fill) {
        int diam = (int)(width / 2.0);
        int wdth = (int)width;
        if (fill) {
            g.fillOval((int)p.x - diam, (int)p.y - diam, wdth, wdth);
        } else {
            g.drawOval((int)p.x - diam, (int)p.y - diam, wdth, wdth);
        }
    }

    public static void paintPoint(Graphics2D g, Point2D.Double p) {
        g.fillOval((int)p.x - 1, (int)p.y - 1, 4, 4);
    }

    public static void paintWorld(Graphics2D g, double margin) {
        g.drawRect((int)margin, (int)margin, (int)(worldWidth - 2.0 * margin), (int)(worldHeight - 2.0 * margin));
    }
}

