/*
 * Decompiled with CFR 0.152.
 */
package knackibot;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import knackibot.KnackOnOne;
import knackibot.MyUtils;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;

public class Enemy {
    private double energyLastTurn;
    private double energy = 100.0;
    private double velocity = 0.0;
    private double bearingRadian = 0.0;
    private double lastBearingRadian = 0.0;
    private double distance = 0.0;
    private double headingRadian = 0.0;
    private String name = "";
    private int nrBulletsHitKnackiThisRound = 0;
    private int nrBulletsFiredThisRound = 0;
    private static List<Point2D.Double> posLog = new ArrayList<Point2D.Double>();

    public void processOnBulletHit(BulletHitEvent event) {
        this.energyLastTurn = event.getEnergy();
    }

    public void processOnScannedRobot(ScannedRobotEvent e) {
        this.energy = e.getEnergy();
        this.velocity = e.getVelocity();
        this.lastBearingRadian = this.bearingRadian;
        this.bearingRadian = e.getBearingRadians();
        this.distance = e.getDistance();
        this.headingRadian = e.getHeadingRadians();
        this.name = e.getName();
        double energyDifference = this.energyLastTurn - this.energy;
        if (energyDifference >= 0.1 && energyDifference <= 3.0) {
            ++this.nrBulletsFiredThisRound;
        }
        this.energyLastTurn = this.energy;
    }

    public void addShotHitMe() {
        ++this.nrBulletsHitKnackiThisRound;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getBearingRadians() {
        return this.bearingRadian;
    }

    public double getLastBearingRadians() {
        return this.lastBearingRadian;
    }

    public double getDistance() {
        return this.distance;
    }

    public int getNrBulletsFiredThisRound() {
        return this.nrBulletsFiredThisRound;
    }

    public int getNrBulletsHitKnackiThisRound() {
        return this.nrBulletsHitKnackiThisRound;
    }

    public String getName() {
        return this.name;
    }

    public void addPosLog(KnackOnOne me) {
        Point2D.Double p = MyUtils.calcPoint(me.ownPos, this.distance, me.getHeadingRadians() + this.bearingRadian);
        p.x = MyUtils.roundDouble(p.x, 3);
        p.y = MyUtils.roundDouble(p.y, 3);
        posLog.add(p);
    }

    public Point2D.Double getCurrentPosition() {
        int posLogSize = this.getPosLogSize();
        return posLogSize > 0 ? posLog.get(posLogSize - 1) : new Point2D.Double(0.0, 0.0);
    }

    public int getPosLogSize() {
        return posLog.size();
    }

    public Point2D.Double getPosLogAt(int i) {
        if (posLog.size() > i) {
            return posLog.get(i);
        }
        throw new IndexOutOfBoundsException("Index " + i + " is out of bounds!");
    }

    public void cleanupMemorySizePosLog(int maxSize) {
        int curPosLogSize = posLog.size();
        if (curPosLogSize > maxSize) {
            int i = 0;
            while (i < curPosLogSize - maxSize) {
                posLog.remove(0);
                ++i;
            }
        }
    }
}

