/*
 * Decompiled with CFR 0.152.
 */
package kronenthaler.common;

public class Util {
    public static final double DOUBLE_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;

    public static double getBulletVelocity(double bulletPower) {
        return 20.0 - 3.0 * bulletPower;
    }

    public static double getTurnVelocity(double velocity) {
        return 10.0 - 0.75 * Math.abs(velocity);
    }

    public static double getNextVelocity(double velocity) {
        return velocity > 0.0 ? velocity + 1.0 : velocity + 2.0;
    }

    public static double projectX(double radius, double angle, double center) {
        return center + Math.sin(Math.toRadians(angle)) * radius;
    }

    public static double projectY(double radius, double angle, double center) {
        return center + Math.cos(Math.toRadians(angle)) * radius;
    }

    public static double calculateBearingToXYRadians(double sourceX, double sourceY, double sourceHeading, double targetX, double targetY) {
        return Util.normalizeRelativeAngleRadians(Math.atan2(targetX - sourceX, targetY - sourceY) - sourceHeading);
    }

    public double normalizeAbsoluteAngleRadians(double angle) {
        if (angle < 0.0) {
            return Math.PI * 2 + angle % (Math.PI * 2);
        }
        return angle % (Math.PI * 2);
    }

    public static double normalizeRelativeAngleRadians(double angle) {
        double trimmedAngle = angle % (Math.PI * 2);
        if (trimmedAngle > Math.PI) {
            return -(Math.PI - trimmedAngle % Math.PI);
        }
        if (trimmedAngle < -Math.PI) {
            return Math.PI + trimmedAngle % Math.PI;
        }
        return trimmedAngle;
    }

    public static double distance(double x, double y, double x1, double y1) {
        return Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1));
    }
}

