/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.bullet;

import dmh.robocode.bullet.SimulatedBullet;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.utils.Geometry;

public class PerfectSimulatedBullet
extends SimulatedBullet {
    private double perfectBearing;
    private Location perfectTarget;
    private Location enemyStartLocation;
    private double enemyStartHeading;
    private double enemyStartVelocity;

    public PerfectSimulatedBullet(EnemyRobot enemy, Location startLocation, long startTime, double velocity) {
        super(enemy, startLocation, startTime, 0.0, velocity);
        this.enemyStartLocation = enemy.getLatestRadarObservation().getLocation();
        this.enemyStartHeading = enemy.getLatestRadarObservation().getHeading();
        this.enemyStartVelocity = enemy.getLatestRadarObservation().getVelocity();
    }

    @Override
    public void processAtTime(long time) {
        if (this.getResult() == SimulatedBullet.BulletResult.IN_PROGRESS) {
            this.changeBearing(Geometry.getBearingBetweenLocations(this.getFiredFrom(), this.getEnemy().getLatestRadarObservation().getLocation()));
            super.processAtTime(time);
            if (this.getResult() == SimulatedBullet.BulletResult.HIT) {
                this.perfectBearing = this.getBearing();
                this.perfectTarget = this.getEnemy().getLatestRadarObservation().getLocation();
                this.getEnemy().informPerfectHit(this);
            }
        }
    }

    public double getPerfectBearing() {
        return this.perfectBearing;
    }

    public Location getPerfectTarget() {
        return this.perfectTarget;
    }

    public Location getEnemyStartLocation() {
        return this.enemyStartLocation;
    }

    public double getEnemyStartHeading() {
        return this.enemyStartHeading;
    }

    public double getEnemyStartVelocity() {
        return this.enemyStartVelocity;
    }
}

