/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.Location;

public class AverageLocation {
    private double weightingIncreaseFactor;
    double x = 0.0;
    double y = 0.0;
    double totalWeight = 0.0;
    double nextWeight = 1.0;

    public AverageLocation(double weightingIncreaseFactor) {
        this.weightingIncreaseFactor = weightingIncreaseFactor;
    }

    public void recordLocation(Location location) {
        this.x = (this.totalWeight * this.x + this.nextWeight * location.getX()) / (this.totalWeight + this.nextWeight);
        this.y = (this.totalWeight * this.y + this.nextWeight * location.getY()) / (this.totalWeight + this.nextWeight);
        this.totalWeight += this.nextWeight;
        this.nextWeight *= this.weightingIncreaseFactor;
    }

    public Location getAverageLocation() {
        if (this.totalWeight > 0.0) {
            return new Location(this.x, this.y);
        }
        return null;
    }
}

