/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.util.List;

public class AimForRecentLocation
extends CalibratedAimingStrategy {
    public AimForRecentLocation(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        Location target = this.getTargetForShot(bulletSpeed);
        if (target == null) {
            return 0.0;
        }
        int timeRange = Math.max(20, this.getApproximateTimeUntilHitTarget(target, bulletSpeed));
        List<RadarObservation> observations = this.getEnemy().getObservationsSince(this.getMyRobot().getTime() - (long)timeRange);
        double targetDelta = Math.min(this.getMyRobot().getHeight(), this.getMyRobot().getWidth()) / 2.0;
        double hits = 0.0;
        for (RadarObservation observation : observations) {
            if (!observation.getLocation().isSameAs(target, targetDelta)) continue;
            hits += this.scoreForHitting(timeRange, this.getMyRobot().getTime() - observation.getTimeSeen());
        }
        return hits * 100.0 / (double)(timeRange + 1);
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        RadarObservation latestObservation = this.getEnemy().getLatestRadarObservation();
        if (latestObservation != null) {
            return latestObservation.getLocation();
        }
        return null;
    }

    private double scoreForHitting(int timeRange, long ageOfObservation) {
        if (ageOfObservation >= (long)(timeRange / 3)) {
            return 1.7;
        }
        if (ageOfObservation >= (long)(timeRange / 3 * 2)) {
            return 1.0;
        }
        return 0.3;
    }

    private int getApproximateTimeUntilHitTarget(Location target, double bulletSpeed) {
        double distance = Geometry.getDistanceBetweenLocations(this.getMyRobot().getLocation(), target);
        return (int)(distance / bulletSpeed);
    }
}

