/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.simulator;

import dmh.robocode.data.CompleteMovementSequence;
import dmh.robocode.data.DynamicMovementSequence;
import dmh.robocode.data.Location;
import dmh.robocode.data.Movement;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.enemy.EnemyRobotMovementAnalyser;
import dmh.robocode.gunner.simulator.EnemySimulator;
import dmh.robocode.utils.Geometry;

public class MovementSequenceReplayEnemySimulator
implements EnemySimulator {
    private Location location;
    long currentTime;
    private DynamicMovementSequence allRecentMovements;
    private CompleteMovementSequence replayMovements;
    private EnemyRobotMovementAnalyser enemyMovementAnalyser;
    private double heading;
    private double velocity;
    private int replayIndex = 0;
    private double probabilityTotal = 0.0;
    private int probabilityCount = 0;

    public MovementSequenceReplayEnemySimulator(EnemyRobot enemy) {
        this.location = enemy.getLatestRadarObservation().getLocation();
        this.currentTime = enemy.getLatestRadarObservation().getTimeSeen();
        this.allRecentMovements = enemy.getMovementSequenceCloneSinceTime(this.currentTime - 20L);
        this.replayMovements = null;
        this.enemyMovementAnalyser = enemy.getMovementAnalyser();
        this.heading = enemy.getLatestRadarObservation().getHeading();
        this.velocity = enemy.getLatestRadarObservation().getVelocity();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public double getProbability() {
        return this.probabilityTotal / (double)this.probabilityCount;
    }

    @Override
    public void takeOneTurn() {
        if (this.replayMovements == null || this.replayIndex >= this.replayMovements.getLength()) {
            this.chooseNextReplaySequence();
        }
        double relativeBearing = 0.0;
        if (this.replayMovements != null) {
            relativeBearing = this.replayMovements.getMovement(this.replayIndex).getRelativeBearing();
            this.heading += relativeBearing;
            this.velocity = this.replayMovements.getMovement(this.replayIndex).getDistance();
            ++this.replayIndex;
        }
        this.location = Geometry.getLocationAtBearing(this.location, this.heading, this.velocity);
        ++this.currentTime;
        this.allRecentMovements.add(new Movement(relativeBearing, this.velocity), this.currentTime);
        if (this.replayMovements != null) {
            // empty if block
        }
    }

    private void chooseNextReplaySequence() {
        EnemyRobotMovementAnalyser.Prediction prediction = this.enemyMovementAnalyser.predictNextMoves(this.allRecentMovements, this.currentTime);
        this.replayMovements = prediction.getSequence();
        this.replayIndex = 0;
        if (this.replayMovements != null) {
            this.probabilityTotal += prediction.getProbability();
        }
        ++this.probabilityCount;
    }
}

