/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.navigator;

import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.navigator.NavigatorCommand;
import dmh.robocode.simulate.SimulateableRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Graphics2D;

public class NavigateRightAnglesToEnemy
implements NavigatorCommand {
    private EnemyRobot enemy;
    private SimulateableRobot myRobot;
    private int timeUntilSwitch;
    private double direction = 1.0;
    private double velocity;

    public NavigateRightAnglesToEnemy(EnemyRobot enemy, SimulateableRobot myRobot, double velocity) {
        this.enemy = enemy;
        this.myRobot = myRobot;
        this.timeUntilSwitch = 1000;
        this.velocity = velocity;
    }

    @Override
    public void setWiggleFactor(int wiggleFactor) {
    }

    @Override
    public int getWiggleFactor() {
        return 0;
    }

    @Override
    public void setWiggleExpiry(long wiggleExpiry) {
    }

    @Override
    public long getWiggleExpiry() {
        return 0L;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public double getRightTurn() {
        double enemyBearing = Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), this.enemy.getLatestRadarObservation().getLocation());
        double turnA = Geometry.getRelativeBearing(this.myRobot.getHeading(), enemyBearing + 90.0);
        double turnB = Geometry.getRelativeBearing(this.myRobot.getHeading(), enemyBearing - 90.0);
        if (Math.abs(turnA) < Math.abs(turnB)) {
            return turnA;
        }
        return turnB;
    }

    @Override
    public double getAhead() {
        return this.velocity;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    public EnemyRobot getEnemy() {
        return this.enemy;
    }

    @Override
    public void executed() {
        if (this.timeUntilSwitch-- <= 0) {
            this.timeUntilSwitch = 10;
            this.direction = -this.direction;
        }
    }

    @Override
    public void reverseDirection() {
    }

    @Override
    public void paint(Graphics2D g) {
    }
}

