/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.gun.nn;

import catcat20.atom.gun.Gun;
import catcat20.atom.gun.WaveGun;
import catcat20.atom.move.surf.Surfing;
import catcat20.atom.rader.AtomRader;
import catcat20.atom.robot.Bot;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.Wave;
import dsekercioglu.roboneural.format.FeatureSplitter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class NeuralGun
extends Gun
implements WaveGun {
    public static final int BINS = 51;
    public static final int MIDDLE_BIN = 25;
    Point2D.Double _myPos;
    Wave lastWave;

    public NeuralGun(TeamRobot _robot) {
        super(_robot);
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
        Bot bot;
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        if (Surfing.nextLocation != null) {
            this._myPos.setLocation(Surfing.nextLocation);
        }
        if ((bot = AtomRader.nearestBot) != null && !bot.gunNeuralInput.isEmpty()) {
            for (int i = 0; i < 8; ++i) {
                int index = (int)(Math.random() * (double)Math.min(200, bot.gunNeuralInput.size()));
                bot.gunNeuralModel.backPropogate(bot.gunNeuralInput.get((int)index).preprocessedData, bot.gunNeuralInput.get((int)index).bins);
            }
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent e, Wave w) {
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e, Wave w) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public double getAngle() {
        Bot bot;
        if (this.lastWave != null && (bot = AtomRader.nearestBot) != null) {
            int firingBin = dsekercioglu.roboneural.format.Utils.getBin(bot.gunNeuralModel.getOutput(this.lastWave.preprocessedData));
            double binWidth = HUtils.maxEscapeAngle(this.lastWave.bulletVelocity()) / 51.0;
            double firingAngle = HUtils.absoluteBearing(this._myPos, bot.currentState.getPosition()) + (double)this.lastWave.direction * binWidth * (double)(firingBin - 25);
            return firingAngle;
        }
        return HUtils.absoluteBearing(this._myPos, HConstants.fieldCenter);
    }

    @Override
    public Color getColor() {
        return Color.magenta;
    }

    @Override
    public String getLabel() {
        return "Neural";
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    @Override
    public void logHit(Wave w, Point2D.Double hitLocation) {
        Bot bot = AtomRader.nearestBot;
        if (bot != null) {
            double binWidth = HUtils.maxEscapeAngle(this.lastWave.bulletVelocity()) / 51.0;
            int bin = (int)Math.round(Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(this._myPos, bot.currentState.getPosition()) - w.directAngle)) / ((double)w.direction * binWidth) + 25.0);
            bin = HUtils.limit(0, bin, 50);
            double[] bins = new double[51];
            for (int x = 0; x < bins.length; ++x) {
                int n = x;
                bins[n] = bins[n] + 1.0 / Math.pow(Math.abs(x - bin) + 1, 2.0);
            }
            bins[bin] = 1.0;
            w.bins = bins;
            bot.gunNeuralInput.add(0, w);
        }
    }

    @Override
    public void update(Wave w) {
        this.lastWave = w;
        if (w != null && w.enState != null) {
            double distance = w.distance(w.enState.getPosition());
            double accel = HUtils.accel(w.enState.latVel, w.prevEnState.latVel);
            double[] data = new double[]{distance / w.bulletVelocity() / 91.0, (w.enState.latVel + 8.0) / 16.0, (accel + 1.0) / 3.0, HUtils.limit(0.0, w.enDirChangeTime / 4.0, 30.0) / 30.0, w.enDist16 / 128.0, w.enMeaWallAhead, w.enMeaWallReverse};
            w.preprocessedData = FeatureSplitter.split(data, AtomRader.getBot((String)w.enName).gunNeuralSplitNum);
        }
    }
}

