/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ListIterator;
import lazarecki.robot.painter.PainterModule;
import lazarecki.robot.strategy.AbstractDataModule;

public class DataPainterModule
extends PainterModule {
    private AbstractDataModule dataModule;
    private Color histogramColor;
    private Color activeSegmentColor;
    private Color inactiveSegmentColor;
    private Point2D origin;

    public DataPainterModule(AbstractDataModule dataModule) {
        this.dataModule = dataModule;
        this.inactiveSegmentColor = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 192);
        this.histogramColor = this.activeSegmentColor = new Color(Color.LIGHT_GRAY.getRed(), Color.LIGHT_GRAY.getGreen(), Color.LIGHT_GRAY.getBlue(), 192);
        this.origin = new Point2D.Double(20.0, 60.0);
    }

    public AbstractDataModule getDataModule() {
        return this.dataModule;
    }

    public Color getHistogramColor() {
        return this.histogramColor;
    }

    public void setHistogramColor(Color histogramColor) {
        this.histogramColor = histogramColor;
    }

    public Color getActiveSegmentColor() {
        return this.activeSegmentColor;
    }

    public void setActiveSegmentColor(Color activeSegmentColor) {
        this.activeSegmentColor = activeSegmentColor;
    }

    public Color getInactiveSegmentColor() {
        return this.inactiveSegmentColor;
    }

    public void setInactiveSegmentColor(Color inactiveSegmentColor) {
        this.inactiveSegmentColor = inactiveSegmentColor;
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point2D origin) {
        this.origin = origin;
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (this.getDataModule().getDataSegment() == null) {
            return;
        }
        this.onPaintHistogram(g, this.getOrigin().getX(), this.getOrigin().getY(), 140.0, 140.0);
        ListIterator<String> nameIt = this.getDataModule().getDataIndex().getIndexNames().listIterator();
        while (nameIt.hasNext()) {
            int i = nameIt.nextIndex();
            String name = nameIt.next();
            if (!nameIt.hasNext()) continue;
            this.onPaintIndex(g, name, this.getOrigin().getX(), this.getOrigin().getY() - (double)((i + 1) * 10), 140.0, 8.0);
        }
    }

    protected void onPaintHistogram(Graphics2D g, double x, double y, double width, double height) {
        g.setColor(this.getHistogramColor());
        double barWidth = width / (double)this.getDataModule().getDataSegment().getSegments();
        int i = 0;
        while (i < this.getDataModule().getDataSegment().getSegments()) {
            g.fillRect((int)(x + barWidth * (double)i), (int)y, (int)barWidth, (int)(height * this.getDataModule().getDataSegment().getValueAt(i)));
            g.drawRect((int)(x + barWidth * (double)i), (int)y, (int)barWidth, (int)(height * this.getDataModule().getDataSegment().getValueAt(i)));
            ++i;
        }
    }

    protected void onPaintIndex(Graphics2D g, String segmentName, double x, double y, double width, double height) {
        double barWidth = width / (double)this.getDataModule().getDataIndex().getSegmentsByName(segmentName);
        int i = 0;
        while (i < this.getDataModule().getDataIndex().getSegmentsByName(segmentName)) {
            g.setColor(this.getDataModule().getDataQuery().getQuerySegments().contains(String.valueOf(segmentName) + ":" + i) ? this.getActiveSegmentColor() : this.getInactiveSegmentColor());
            g.fillRect((int)(x + barWidth * (double)i), (int)y, (int)barWidth, (int)height);
            g.drawRect((int)(x + barWidth * (double)i), (int)y, (int)barWidth, (int)height);
            ++i;
        }
    }
}

