/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.event.DestinationChangedEvent;
import lazarecki.robot.strategy.MetaStrategist;
import lazarecki.robot.strategy.Strategist;
import lazarecki.util.RoboUtils;

public class GravityMovementModule
extends MetaStrategist {
    private Map<Strategist, Double> gravityValues = new HashMap<Strategist, Double>();
    private List<GravityForce> gravityForces = new LinkedList<GravityForce>();
    private List<GravityForce> currentTurnForces = new LinkedList<GravityForce>();
    private double currentTurnTotalForce;

    public List<GravityForce> getGravityForces() {
        return this.gravityForces;
    }

    public double calculateTotalGravityValue() {
        double totalGravityValue = 0.0;
        for (GravityForce force : this.getGravityForces()) {
            totalGravityValue += force.getForce();
        }
        return totalGravityValue;
    }

    public boolean add(Strategist strategist, double gravityForce) {
        if (!super.add(strategist)) {
            return false;
        }
        this.gravityValues.put(strategist, gravityForce);
        return true;
    }

    @Override
    public boolean add(Strategist strategist) {
        return this.add(strategist, 1.0);
    }

    @Override
    public boolean remove(Strategist strategist) {
        if (!super.remove(strategist)) {
            return false;
        }
        this.gravityValues.remove(strategist);
        return true;
    }

    @Override
    public void onRun() {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        Point2D dest = myInfo.getPosition();
        for (GravityForce force : this.currentTurnForces) {
            Point2D attractor = force.getAttractor();
            double absAngle = myInfo.absoluteAngle(attractor);
            double distance = myInfo.distance(attractor);
            dest = RoboUtils.projectPoint(dest, absAngle, force.getForce() * distance / this.currentTurnTotalForce);
        }
        this.getRobot().setDestination(dest);
        this.getRobot().moveToDestination();
        this.gravityForces.clear();
        this.gravityForces.addAll(this.currentTurnForces);
        this.currentTurnTotalForce = 0.0;
        this.currentTurnForces.clear();
    }

    @Override
    public void onDestinationChanged(DestinationChangedEvent event) {
        if (this.getActive() == null) {
            return;
        }
        double gravity = this.gravityValues.get(this.getActive());
        this.currentTurnTotalForce += gravity;
        this.currentTurnForces.add(new GravityForce(event.getDestination(), gravity));
    }

    public class GravityForce {
        private Point2D attractor;
        private double force;

        public GravityForce(Point2D attractor, double force) {
            this.attractor = attractor;
            this.force = force;
        }

        public Point2D getAttractor() {
            return this.attractor;
        }

        public double getForce() {
            return this.force;
        }
    }
}

