/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.util;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import lazarecki.robot.RobotInfo;
import robocode.Rules;
import robocode.util.Utils;

public class RoboUtils {
    public static double projectAbsoluteAngle(Point2D source, Point2D target) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    public static double projectAbsoluteAngle(RobotInfo source, RobotInfo target) {
        return RoboUtils.projectAbsoluteAngle(source.getPosition(), target.getPosition());
    }

    public static Point2D projectPoint(Point2D source, double absoluteBearing, double distance) {
        return new Point2D.Double(source.getX() + Math.sin(absoluteBearing) * distance, source.getY() + Math.cos(absoluteBearing) * distance);
    }

    public static Point2D projectPoint(RobotInfo source, double absoluteBearing, double distance) {
        return RoboUtils.projectPoint(source.getPosition(), absoluteBearing, distance);
    }

    public static double maxTurnRate(double velocity) {
        return Math.min(Rules.MAX_TURN_RATE_RADIANS, (0.4 + 0.6 * (1.0 - Math.abs(velocity) / 8.0)) * Rules.MAX_TURN_RATE_RADIANS);
    }

    public static double weightedAverage(double oldValue, double newValue, double oldWeight, double newWeight) {
        return (oldValue * oldWeight + newValue * newWeight) / (oldWeight + newWeight);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static Color cloneTransparentColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color createMixedColor(Color c1, Color c2, double ratio) {
        return new Color((int)RoboUtils.limit(0.0, (double)c2.getRed() * ratio + (double)c1.getRed() * (1.0 - ratio), 255.0), (int)RoboUtils.limit(0.0, (double)c2.getGreen() * ratio + (double)c1.getGreen() * (1.0 - ratio), 255.0), (int)RoboUtils.limit(0.0, (double)c2.getBlue() * ratio + (double)c1.getBlue() * (1.0 - ratio), 255.0), (int)RoboUtils.limit(0.0, (double)c2.getAlpha() * ratio + (double)c1.getAlpha() * (1.0 - ratio), 255.0));
    }

    public static Shape createRobotSprite(RobotInfo robot) {
        double heading = robot.getHeadingRadians();
        Point2D head = robot.projectPoint(0.0, 17.5);
        Point2D rear = robot.projectPoint(Math.PI, 17.5);
        Point2D left = RoboUtils.projectPoint(rear, Utils.normalAbsoluteAngle((double)(heading - 1.5707963267948966)), 11.666666666666666);
        Point2D right = RoboUtils.projectPoint(rear, Utils.normalAbsoluteAngle((double)(heading + 1.5707963267948966)), 11.666666666666666);
        Path2D.Double sprite = new Path2D.Double();
        ((Path2D)sprite).moveTo(head.getX(), head.getY());
        ((Path2D)sprite).lineTo(left.getX(), left.getY());
        ((Path2D)sprite).lineTo(right.getX(), right.getY());
        sprite.closePath();
        return sprite;
    }
}

