/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.wave;

import java.awt.geom.Point2D;
import lazarecki.robot.RobotInfo;
import lazarecki.util.RoboUtils;
import robocode.Rules;
import robocode.util.Utils;

public class Wave {
    protected boolean valid;
    protected RobotInfo shooter;
    protected RobotInfo target;
    protected double fireAbsoluteAngle;
    protected double firePower;
    protected ClockDirection direction;

    public static double calculateWaveSpeed(double firePower) {
        return Rules.getBulletSpeed((double)firePower);
    }

    public static double calculateMaxEscapeAngle(double firePower) {
        return Math.asin(8.0 / Wave.calculateWaveSpeed(firePower));
    }

    public static double calculateFireAngleOffset(ClockDirection direction, double guessFactor, double firePower) {
        return Utils.normalRelativeAngle((double)(direction.getFactor() * guessFactor * Wave.calculateMaxEscapeAngle(firePower)));
    }

    public static double calculateGuessFactor(int segments, int segmentIndex) {
        return 2.0 * (double)segmentIndex / ((double)segments - 1.0) - 1.0;
    }

    public Wave(RobotInfo shooter, RobotInfo target, double firePower) {
        this.shooter = shooter;
        this.target = target;
        this.firePower = firePower;
        this.fireAbsoluteAngle = shooter.absoluteAngle(target);
        this.direction = shooter.clockDirection(target);
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public double getBulletSpeed() {
        return Wave.calculateWaveSpeed(this.firePower);
    }

    public double getMaxEscapeAngle() {
        return Wave.calculateMaxEscapeAngle(this.firePower);
    }

    public RobotInfo getInterceptionInfo(RobotInfo surfer, ClockDirection direction) {
        RobotInfo predictedInfo = surfer;
        Point2D predictedPosition = (Point2D)predictedInfo.getPosition().clone();
        double predictedVelocity = predictedInfo.getVelocity();
        double predictedHeading = predictedInfo.getHeadingRadians();
        int i = 1;
        while (i < 500) {
            double absBearing = this.getShooter().absoluteAngle(predictedPosition);
            double maxTurning = RoboUtils.maxTurnRate(Math.abs(predictedVelocity));
            double moveAngle = Utils.normalRelativeAngle((double)(absBearing + 1.5707963267948966 * direction.getFactor() - predictedHeading));
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle = Utils.normalRelativeAngle((double)(moveAngle + Math.PI));
                moveDir = -1.0;
            }
            predictedHeading = Utils.normalAbsoluteAngle((double)(predictedHeading + Utils.normalRelativeAngle((double)RoboUtils.limit(-maxTurning, moveAngle, maxTurning))));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : 1.0 * moveDir;
            RobotInfo newInfo = new RobotInfo(predictedPosition = RoboUtils.projectPoint(predictedPosition, predictedHeading, predictedVelocity = RoboUtils.limit(-8.0, predictedVelocity, 8.0)), predictedHeading, predictedVelocity, this.getTarget().getEnergy(), surfer.getTime() + (long)i, predictedInfo.getBattleFieldWidth(), predictedInfo.getBattleFieldHeight());
            if (this.isGoingUp(newInfo, predictedInfo) && newInfo.getPosition().getY() > newInfo.getBattleFieldHeight() - 50.0 || this.isGoingDown(newInfo, predictedInfo) && newInfo.getPosition().getY() < 50.0 || this.isGoingLeft(newInfo, predictedInfo) && newInfo.getPosition().getX() < 50.0 || this.isGoingRight(newInfo, predictedInfo) && newInfo.getPosition().getX() > newInfo.getBattleFieldWidth() - 50.0) break;
            predictedInfo = newInfo;
            if (this.getShooter().distance(predictedInfo) < this.getDistanceTraveled(predictedInfo.getTime())) break;
            ++i;
        }
        return predictedInfo;
    }

    public boolean isTargetHit(RobotInfo targetWhenHit) {
        return !(targetWhenHit.distance(this.getShooter()) > this.getDistanceTraveled(targetWhenHit.getTime()));
    }

    public RobotInfo getShooter() {
        return this.shooter;
    }

    public RobotInfo getTarget() {
        return this.target;
    }

    public double getAbsoluteFireAngle() {
        return this.fireAbsoluteAngle;
    }

    public double getFirePower() {
        return this.firePower;
    }

    public long getFireTime() {
        return this.shooter.getTime();
    }

    public ClockDirection getDirection() {
        return this.direction;
    }

    public double getDistanceTraveled(long currentTime) {
        return this.getBulletSpeed() * (double)(currentTime - this.getFireTime());
    }

    public double absoluteShooterAngle(Point2D point) {
        return this.getShooter().absoluteAngle(point);
    }

    public double absoluteShooterAngle(RobotInfo info) {
        return this.getShooter().absoluteAngle(info);
    }

    public double absoluteTargetAngle(Point2D point) {
        return this.getTarget().absoluteAngle(point);
    }

    public double absoluteTargetAngle(RobotInfo info) {
        return this.getTarget().absoluteAngle(info);
    }

    public void logTargetHit(RobotInfo targetWhenHit, double hitValue) {
    }

    private boolean isGoingUp(RobotInfo newInfo, RobotInfo oldInfo) {
        return newInfo.getPosition().getY() > oldInfo.getPosition().getY();
    }

    private boolean isGoingDown(RobotInfo newInfo, RobotInfo oldInfo) {
        return newInfo.getPosition().getY() < oldInfo.getPosition().getY();
    }

    private boolean isGoingLeft(RobotInfo newInfo, RobotInfo oldInfo) {
        return newInfo.getPosition().getX() < oldInfo.getPosition().getX();
    }

    private boolean isGoingRight(RobotInfo newInfo, RobotInfo oldInfo) {
        return newInfo.getPosition().getX() > oldInfo.getPosition().getX();
    }

    public static enum ClockDirection {
        Clockwise(1.0),
        Counterclockwise(-1.0);

        private final double factor;

        private ClockDirection(double factor) {
            this.factor = factor;
        }

        public double getFactor() {
            return this.factor;
        }
    }

    public static enum GuessFactor {
        Min(-1.0),
        Max(1.0);

        private double guessFactor;

        public static double normalizeGuessFactor(double factor) {
            return Math.max(Min.getGuessFactor(), Math.min(Max.getGuessFactor(), factor));
        }

        private GuessFactor(double guessFactor) {
            this.guessFactor = guessFactor;
        }

        public double getGuessFactor() {
            return this.guessFactor;
        }
    }
}

