/*
 * Decompiled with CFR 0.152.
 */
package apc.network;

public class NeuralNet {
    public static double[] input;
    public static double[][] w1;
    public static double[] hidden;
    public static double[][] w2;
    public static double[] output;
    public static double[] delta2;
    public static double[] delta1;
    public static int trainedEpochs;

    static {
        trainedEpochs = 0;
    }

    public NeuralNet(int inp, int hid, int outp) {
        input = new double[inp + 1];
        hidden = new double[hid + 1];
        output = new double[outp];
        w1 = new double[inp + 1][hid + 1];
        w2 = new double[hid + 1][outp];
        delta2 = new double[outp];
        delta1 = new double[hid + 1];
        this.initialiseWeights();
    }

    private void initialiseWeights() {
        int j;
        int i = 0;
        while (i < w1.length) {
            j = 0;
            while (j < w1[i].length) {
                NeuralNet.w1[i][j] = Math.random() * 0.8 + 0.1;
                j = (byte)(j + 1);
            }
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < w2.length) {
            j = 0;
            while (j < w2[i].length) {
                NeuralNet.w2[i][j] = Math.random() * 0.8 + 0.1;
                j = (byte)(j + 1);
            }
            i = (byte)(i + 1);
        }
    }

    public void learn(double[] inp, double[] out) {
        double sum;
        int i = 0;
        while (i < inp.length) {
            NeuralNet.input[i] = inp[i];
            ++i;
        }
        int j = 0;
        while (j < hidden.length - 1) {
            sum = 0.0;
            i = 0;
            while (i < input.length) {
                sum += w1[i][j] * input[i];
                ++i;
            }
            NeuralNet.hidden[j] = 1.0 / (1.0 + Math.exp(-sum));
            ++j;
        }
        j = 0;
        while (j < output.length) {
            sum = 0.0;
            i = 0;
            while (i < hidden.length) {
                sum += w2[i][j] * hidden[i];
                ++i;
            }
            NeuralNet.output[j] = 1.0 / (1.0 + Math.exp(-sum));
            ++j;
        }
        j = 0;
        while (j < output.length) {
            double out_j = out[j] == 0.0 ? 0.1 : (out[j] == 1.0 ? 0.9 : out[j]);
            NeuralNet.delta2[j] = output[j] * (1.0 - output[j]) * (out_j - output[j]);
            ++j;
        }
        j = 0;
        while (j < hidden.length) {
            sum = 0.0;
            i = 0;
            while (i < output.length) {
                sum += delta2[i] * w2[j][i];
                ++i;
            }
            NeuralNet.delta1[j] = hidden[j] * (1.0 - hidden[j]) * sum;
            ++j;
        }
        i = 0;
        while (i < hidden.length) {
            j = 0;
            while (j < output.length) {
                NeuralNet.w2[i][j] = w2[i][j] + 0.35 * delta2[j] * hidden[i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < input.length) {
            j = 0;
            while (j < hidden.length) {
                NeuralNet.w1[i][j] = w1[i][j] + 0.35 * delta1[j] * input[i];
                ++j;
            }
            ++i;
        }
    }

    public void test(double[] inp, double[] out) {
        double sum;
        int i = 0;
        while (i < inp.length) {
            NeuralNet.input[i] = inp[i];
            ++i;
        }
        int j = 0;
        while (j < hidden.length - 1) {
            sum = 0.0;
            i = 0;
            while (i < input.length) {
                sum += w1[i][j] * input[i];
                ++i;
            }
            NeuralNet.hidden[j] = 1.0 / (1.0 + Math.exp(-sum));
            ++j;
        }
        j = 0;
        while (j < output.length) {
            sum = 0.0;
            i = 0;
            while (i < hidden.length) {
                sum += w2[i][j] * hidden[i];
                ++i;
            }
            NeuralNet.output[j] = 1.0 / (1.0 + Math.exp(-sum));
            ++j;
        }
        i = 0;
        while (i < output.length) {
            out[i] = output[i];
            ++i;
        }
    }

    public void train(double[] inp, double[] outp) {
        this.learn(inp, outp);
        ++trainedEpochs;
    }

    public String getWeights(String weight) {
        int j = 0;
        String line = "";
        if (weight == "w1") {
            int i = 0;
            while (i < input.length) {
                j = 0;
                while (j < hidden.length) {
                    line = String.valueOf(line) + w1[i][j];
                    line = String.valueOf(line) + ",";
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < hidden.length) {
                j = 0;
                while (j < output.length) {
                    line = String.valueOf(line) + w2[i][j];
                    line = String.valueOf(line) + ",";
                    ++j;
                }
                ++i;
            }
        }
        return line;
    }

    public void convertOutPuts(double[] out) {
        int i = 0;
        i = 0;
        while (i < out.length) {
            out[i] = out[i] >= 0.5 ? 1.0 : 0.0;
            ++i;
        }
    }

    public void enterWieghts(String weights1, String weights2) {
        int j;
        String[] dataArray = weights1.split(",");
        int k = 0;
        int i = 0;
        while (i < input.length) {
            j = 0;
            while (j < hidden.length) {
                NeuralNet.w1[i][j] = Double.parseDouble(dataArray[k]);
                ++k;
                ++j;
            }
            ++i;
        }
        dataArray = weights2.split(",");
        k = 0;
        i = 0;
        while (i < hidden.length) {
            j = 0;
            while (j < output.length) {
                NeuralNet.w2[i][j] = Double.parseDouble(dataArray[k]);
                ++k;
                ++j;
            }
            ++i;
        }
    }
}

