/*
 * Decompiled with CFR 0.152.
 */
package apc.targeting;

import apc.utils.EmData;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Linear {
    private double battleFieldHeight = 1200.0;
    private double battleFieldWidth = 1200.0;

    public Linear(double height, double width) {
        this.battleFieldHeight = height;
        this.battleFieldWidth = width;
    }

    public double targetBot(EmData bot, double energy, double x, double y, double heading) {
        double bulletPower = Math.min(3.0, energy);
        double myX = x;
        double myY = y;
        double absoluteBearing = heading + bot.bearing();
        double enemyX = x + bot.distance() * Math.sin(absoluteBearing);
        double enemyY = y + bot.distance() * Math.cos(absoluteBearing);
        double enemyHeading = bot.heading();
        double enemyVelocity = bot.velocity();
        double deltaTime = 0.0;
        double predictedX = enemyX;
        double predictedY = enemyY;
        if (bot.velocity() != 0.0) {
            enemyVelocity = bot.aveVelocity();
        }
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > this.battleFieldWidth - 18.0) && !(predictedY > this.battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), this.battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), this.battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - x, predictedY - y));
        Point2D.Double newLocation = new Point2D.Double(predictedX, predictedY);
        bot.setPrediction(newLocation);
        return theta;
    }
}

