/*
 * Decompiled with CFR 0.152.
 */
package arthord;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class KostyaTszyu
extends AdvancedRobot {
    static final int GUESS_FACTORS = 41;
    static final int DISTANCE_FACTORS = 12;
    static final int DISTANCE_FACTOR_SIZE = 100;
    static final int VELOCITY_FACTORS = 5;
    static final int VELOCITY_FACTOR_SIZE = 3;
    static final int VELOCITY_FACTOR_OFFSET = 2;
    static final int ACCEL_FACTORS = 3;
    static final int WALL_FACTORS = 2;
    static final int WALL_BUFFER = 100;
    static final int POINT_BLANK = 100;
    static final double BULLET_POWER = 2.4;
    static final double BULLET_VELOCITY = 12.8;
    static final double BEARING_THRESHOLD = 0.7853981633974483;
    static int direction = 1;
    static boolean flat = false;
    static long lastReverseTime;
    static double bulletVelocity;
    static double enemyDistance;
    static double eX;
    static double eY;
    static double eEnergy;
    static double eLastVel;
    static double[][][][] guessFactors;

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(1.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double[] currentFactors;
        double robotHeading;
        double d;
        int bestFactor = 20;
        int i = 40;
        enemyDistance = e.getDistance();
        double absoluteBearing = 1.0 / (enemyDistance / bulletVelocity + (double)4);
        if (Math.random() > Math.pow(d, absoluteBearing) && flat) {
            direction = -direction;
        }
        absoluteBearing = e.getBearingRadians();
        double turnAngle = absoluteBearing + 1.5707963267948966 + (double)direction * Math.PI / 12.0;
        do {
            robotHeading = this.getHeadingRadians();
        } while (!new Rectangle2D.Double(38.0, 38.0, 724.0, 524.0).contains(this.getX() + (double)(130 * direction) * Math.sin(robotHeading + (turnAngle -= (double)direction * 0.02)), this.getY() + (double)(130 * direction) * Math.cos(robotHeading + turnAngle)));
        if (Math.abs(Math.acos((double)direction * Math.cos(absoluteBearing))) < 0.7853981633974483) {
            direction = -direction;
            lastReverseTime = this.getTime();
        }
        this.setAhead(direction * 100);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)turnAngle));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)((absoluteBearing += robotHeading) - this.getRadarHeadingRadians())) * (double)2);
        eX = this.getX() + enemyDistance * Math.sin(absoluteBearing);
        eY = this.getY() + enemyDistance * Math.cos(absoluteBearing);
        eEnergy = e.getEnergy();
        do {
            double[] dArray;
            double[][][] dArray2 = guessFactors[(int)((eLastVel -= e.getVelocity()) / Math.abs(eLastVel)) + 1];
            eLastVel = e.getVelocity();
            currentFactors = dArray2[(int)eLastVel / 3 + 2][(int)enemyDistance / 100];
            if (!(dArray[i] > currentFactors[bestFactor]) || !(eEnergy > 0.0)) continue;
            bestFactor = i;
        } while (--i > 0);
        Wave w = new Wave();
        w.oX = this.getX();
        w.oY = this.getY();
        w.startAbsoluteBearing = absoluteBearing;
        w.guessFactors = currentFactors;
        w.maxPositiveGuessFactor = Math.asin(0.625 * (double)(eLastVel * Math.sin(e.getHeadingRadians() - absoluteBearing) < 0.0 ? -1 : 1));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + ((double)bestFactor / 20.0 - 1.0) * w.maxPositiveGuessFactor)));
        this.addCustomEvent(w);
        if (this.getEnergy() > 2.4 || enemyDistance < 100.0) {
            this.setFire(enemyDistance > 100.0 ? 2.4 : (double)3);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if ((double)(this.getTime() - lastReverseTime) > 0.091 * enemyDistance) {
            flat = true;
        }
        bulletVelocity = e.getVelocity();
    }

    static {
        guessFactors = new double[3][5][12][41];
    }

    private class Wave
    extends Condition {
        double travel;
        double oX;
        double oY;
        double startAbsoluteBearing;
        double maxPositiveGuessFactor;
        double[] guessFactors;

        public boolean test() {
            this.travel += 12.8;
            Point2D.Double double_ = new Point2D.Double(eX, eY);
            if (double_.distance(this.oX, this.oY) - this.travel < 6.4) {
                if (KostyaTszyu.this.getEnergy() > 2.4 && eEnergy > (double)3) {
                    try {
                        int n = (int)Math.round(Utils.normalRelativeAngle((double)(Math.atan2(eX - this.oX, eY - this.oY) - this.startAbsoluteBearing)) / this.maxPositiveGuessFactor * 20.0 + 20.0);
                        this.guessFactors[n] = this.guessFactors[n] + 1.0;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                KostyaTszyu.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

