/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Enemy;
import et.EtMath;
import et.Predator;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import robocode.Bullet;

public final class Gunner {
    private String lastFiredAt = null;
    private ArrayList bulletList;
    private double firePower = 0.0;
    private boolean setFire = false;
    private static double totalHits = 0.0;
    private static double totalShots = 0.0;
    private static double totalTimesHitTarget = 0.0;
    private static long totalTimesFired = 0L;
    private static Predator thePredator;
    private static double totalDamage;
    private boolean firePowerSelected = false;
    private Enemy currentTarget = null;
    private boolean targetSelected = false;
    public static double AvgSucTf;

    public Gunner(Predator predator) {
        thePredator = predator;
        this.bulletList = new ArrayList();
    }

    public final void reset() {
        this.setFire = false;
        this.firePowerSelected = false;
    }

    private final double computeTargetFactor(Enemy enemy) {
        return (1.0 - thePredator.getCurrentThreat(enemy) / 2.0) * Math.pow(enemy.getEstimatedDistance(enemy.getDistance() / 16.0) / 40.0, 2.0) * (1.0 + Math.abs(enemy.getAvgVelocity(enemy.getDistance() / 16.0)) / 16.0) * (enemy.isOnMyWall() ? 0.25 : 1.0) * (1.0 + Math.abs(enemy.getBearingToGun()) / 45.0);
    }

    private final Enemy bestTarget(Enemy enemy, Enemy enemy2) {
        if (enemy == null) {
            return enemy2;
        }
        if (enemy2 == null) {
            return enemy;
        }
        if (this.computeTargetFactor(enemy) < this.computeTargetFactor(enemy2)) {
            return enemy;
        }
        return enemy2;
    }

    private void selectTarget() {
        if (Predator.theEnemyMap.size() == 0) {
            return;
        }
        ListIterator listIterator = ((AbstractList)Predator.theEnemyMap).listIterator();
        while (listIterator.hasNext()) {
            Enemy enemy = (Enemy)listIterator.next();
            if ((this.currentTarget == null || !this.currentTarget.isUpdated()) && enemy != null && enemy.isUpdated()) {
                this.currentTarget = enemy;
                continue;
            }
            if (enemy == null || this.currentTarget == null || !enemy.isUpdated()) continue;
            this.currentTarget = this.bestTarget(enemy, this.currentTarget);
        }
    }

    private double computeFirePower(double d) {
        double d2 = 0.0;
        double d3 = this.currentTarget.getAvgVelocity(d / 16.0);
        double d4 = Math.max(0.1, 3.0 / (Math.pow((1.0 + d3 / 16.0) * d / 800.0, 7.0) + 1.0));
        double d5 = Math.min(3.0, Math.min(this.currentTarget.getEnergy() / 4.0 + 0.1, thePredator.getEnergy() / 25.0 + 0.05));
        if (thePredator.getOthers() == 1) {
            d5 = Math.min(3.0, Math.min(this.currentTarget.getEnergy() / 4.0 + 0.1, thePredator.getEnergy() / 5.0 + 0.05));
        }
        if (d5 < 0.1 && thePredator.getEnergy() > 0.1) {
            d5 = 0.1;
        }
        d4 = thePredator.getOthers() == 1 && this.currentTarget.getDistance() > 80.0 ? (d4 *= EtMath.rand(0.5, 3.0)) : (d4 *= EtMath.rand(1.0, 3.0));
        if (d4 < 0.1) {
            d4 = 0.1;
        }
        d2 = Math.min(d4, d5);
        return d2;
    }

    public void aimAtTarget() {
        if (!(this.setFire || this.currentTarget != null && this.currentTarget.isUpdated() && this.targetSelected)) {
            this.selectTarget();
        } else if (this.setFire && this.currentTarget == null) {
            this.setFire = false;
            this.selectTarget();
        }
        if (this.currentTarget == null || this.setFire) {
            return;
        }
        this.targetSelected = true;
        double d = this.currentTarget.getDistance();
        if (!this.firePowerSelected) {
            this.firePower = this.computeFirePower(d);
            if (this.firePower > 0.1) {
                this.firePowerSelected = true;
            }
        }
        long l = Math.round(d / (20.0 - 3.0 * this.firePower));
        long l2 = 0L;
        int n = 0;
        while (Math.abs(l2 - l) > 0L && n++ < 100) {
            d = this.currentTarget.getEstimatedDistance(l);
            l2 = l;
            l = Math.round(d / (20.0 - 3.0 * this.firePower));
        }
        double d2 = thePredator.getAngleToLocationFromHeading(this.currentTarget.getEstimatedPosition(l), thePredator.getGunHeading());
        thePredator.setTurnGunRight(d2);
        if (this.firePower < 0.1 || thePredator.getGunHeat() > 0.0) {
            return;
        }
        this.lastFiredAt = this.currentTarget.getName();
        this.setFire = true;
        this.firePowerSelected = false;
    }

    public final boolean readyToFire() {
        return this.setFire && Math.abs(thePredator.getGunTurnRemaining()) < 0.1;
    }

    public void fireAtTarget() {
        Bullet bullet = thePredator.fireBullet(this.firePower);
        this.bulletList.add(new BulletWrp(bullet, this.lastFiredAt, this.currentTarget != null ? this.currentTarget.nextTf : 10.0));
        ++totalTimesFired;
        this.setFire = false;
        this.targetSelected = false;
    }

    public void processBulletList() {
        ListIterator listIterator = ((AbstractList)this.bulletList).listIterator();
        while (listIterator.hasNext()) {
            BulletWrp bulletWrp = (BulletWrp)listIterator.next();
            if (bulletWrp == null || bulletWrp.getBullet() == null) continue;
            if (bulletWrp.getBullet().getVictim() != null) {
                if (bulletWrp.getTarget() != null) {
                    if (bulletWrp.getTarget().equals(bulletWrp.getBullet().getVictim())) {
                        Predator.theEnemyMap.setHit(bulletWrp.getTarget(), bulletWrp.getBullet().getPower(), bulletWrp.tf);
                        totalTimesHitTarget += 1.0;
                    }
                    Predator.theEnemyMap.setFiredAt(bulletWrp.getTarget(), bulletWrp.getBullet().getPower());
                }
                totalHits += bulletWrp.getBullet().getPower();
                totalShots += bulletWrp.getBullet().getPower();
                double d = bulletWrp.getBullet().getPower() * 4.0;
                if (bulletWrp.getBullet().getPower() > 1.0) {
                    d += 2.0 * (bulletWrp.getBullet().getPower() - 1.0);
                }
                totalDamage += d;
                listIterator.remove();
                continue;
            }
            if (bulletWrp.getBullet().isActive()) continue;
            if (bulletWrp.getTarget() != null) {
                Predator.theEnemyMap.setFiredAt(bulletWrp.getTarget(), bulletWrp.getBullet().getPower());
            }
            totalShots += bulletWrp.getBullet().getPower();
            listIterator.remove();
        }
    }

    public void printStats(PrintStream printStream) {
        printStream.print("Hits: " + EtMath.percent(totalHits / totalShots) + " (" + (long)totalHits + "/" + (long)totalShots + "). ");
        printStream.println("Avg. firepower=" + EtMath.decimals(totalShots / (double)totalTimesFired, 2));
        printStream.println("Damage/round: " + totalDamage / (double)(1 + thePredator.getRoundNum()));
    }

    static {
        totalDamage = 0.0;
        AvgSucTf = 10.0;
    }

    class BulletWrp {
        private String target;
        public double tf;
        private Bullet bullet;

        public BulletWrp(Bullet bullet, String string, double d) {
            this.target = string;
            this.bullet = bullet;
            this.tf = d;
        }

        public final String getTarget() {
            return this.target;
        }

        public final Bullet getBullet() {
            return this.bullet;
        }
    }
}

