/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Enemy;
import et.EtMath;
import et.Predator;
import java.util.AbstractList;
import java.util.ListIterator;

public final class Radar {
    private static double sweeps = 1.0;
    private static double smSweeps = 0.0;
    private double radarDirection = 1.0;
    private static Predator thePredator;

    public Radar(Predator predator) {
        thePredator = predator;
    }

    public void sweep() {
        sweeps += 1.0;
        double d = 90.0 * this.radarDirection;
        double d2 = 0.0;
        double d3 = -180.0;
        double d4 = 0.0;
        double d5 = 0.0;
        ListIterator listIterator = ((AbstractList)Predator.theEnemyMap).listIterator();
        while (listIterator.hasNext()) {
            Enemy enemy = (Enemy)listIterator.next();
            if (enemy == null || !enemy.isUpdated()) continue;
            double d6 = EtMath.normalRelativeAngle(thePredator.getHeading() + enemy.getBearing() - thePredator.getRadarHeading());
            if (Math.abs(d6) > d3) {
                d3 = Math.abs(d6);
                d4 = d6;
            }
            d2 += 1.0;
        }
        if (d2 >= (double)thePredator.getOthers()) {
            smSweeps += 1.0;
            d = (double)EtMath.sign(d4) * 22.5 + d4;
        }
        thePredator.setTurnRadarRight(d);
        this.radarDirection = EtMath.sign(d);
    }

    public String getStats() {
        return "Smart sweeps: " + EtMath.percent(smSweeps / sweeps);
    }
}

