/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.base;

import robocode.TeamRobot;

public class Rules {
    public final double ACCELERATION = 1.0;
    public final double DECELERATION = 2.0;
    public final double GUN_TURN_RATE = robocode.Rules.GUN_TURN_RATE_RADIANS;
    public final double MAX_BULLET_POWER = 3.0;
    public final double MAX_TURN_RATE = robocode.Rules.MAX_TURN_RATE_RADIANS;
    public final double MAX_VELOCITY = 8.0;
    public final double MIN_BULLET_POWER = 0.1;
    public final double RADAR_SCAN_RADIUS = 1200.0;
    public final double RADAR_TURN_RATE = robocode.Rules.RADAR_TURN_RATE_RADIANS;
    public final double ROBOT_HIT_BONUS = 1.2;
    public final double ROBOT_HIT_DAMAGE = 0.6;
    public final double GUN_COOLING_RATE;
    public final double BATTLEFIELD_WIDTH;
    public final double BATTLEFIELD_HEIGHT;
    public final String[] TEAMMATES;
    public final int ENEMIES;
    public final String NAME;

    public double getBulletDamage(double bulletPower) {
        return robocode.Rules.getBulletDamage((double)bulletPower);
    }

    public double getBulletHitBonus(double bulletPower) {
        return robocode.Rules.getBulletHitBonus((double)bulletPower);
    }

    public double getBulletSpeed(double bulletPower) {
        return robocode.Rules.getBulletSpeed((double)bulletPower);
    }

    public double getGunHeat(double bulletPower) {
        return robocode.Rules.getGunHeat((double)bulletPower);
    }

    public double getTurnRate(double velocity) {
        return robocode.Rules.getTurnRateRadians((double)velocity);
    }

    public double getWallHitDamage(double velocity) {
        return robocode.Rules.getWallHitDamage((double)velocity);
    }

    public Rules(TeamRobot peer) {
        this.GUN_COOLING_RATE = peer.getGunCoolingRate();
        this.BATTLEFIELD_WIDTH = peer.getBattleFieldWidth();
        this.BATTLEFIELD_HEIGHT = peer.getBattleFieldHeight();
        this.TEAMMATES = peer.getTeammates() != null ? peer.getTeammates() : new String[0];
        this.NAME = peer.getName();
        this.ENEMIES = peer.getOthers() - this.TEAMMATES.length;
    }

    public boolean isTeammate(String name) {
        if (this.TEAMMATES == null) {
            return false;
        }
        String[] stringArray = this.TEAMMATES;
        int n = this.TEAMMATES.length;
        int n2 = 0;
        while (n2 < n) {
            String teammate = stringArray[n2];
            if (teammate.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public double damageToBulletPower(double energy) {
        if (energy / 4.0 <= 1.0) {
            return energy / 4.0;
        }
        return (energy + 2.0) / 6.0;
    }

    public double getHitRegneration(double bulletPower) {
        return 3.0 * bulletPower;
    }
}

