/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.movement;

import ags.muse.base.Rules;
import ags.muse.recon.Enemy;
import ags.muse.recon.EnemyList;
import ags.rougedc.movement.RobotDriver;
import ags.rougedc.movement.WallSmoother;
import ags.rougedc.robots.VirtualRobot;
import ags.rougedc.waves.EnemyWave;
import ags.util.points.RelativePoint;
import java.util.Iterator;
import java.util.List;
import robocode.util.Utils;

public class DistanceDriver
implements RobotDriver {
    private final Rules rules;
    private final EnemyList enemies;
    private final double goaldistance;
    private double acceleration;
    private double turn;

    public DistanceDriver(Rules rules, EnemyList enemies, double goaldistance) {
        this.rules = rules;
        this.enemies = enemies;
        this.goaldistance = goaldistance;
    }

    @Override
    public void run(VirtualRobot bot, List<EnemyWave> waves) {
        WallSmoother smoother = new WallSmoother(this.rules);
        Enemy target = null;
        Iterator<Enemy> iterator = this.enemies.getBots().iterator();
        while (iterator.hasNext()) {
            Enemy e;
            target = e = iterator.next();
        }
        if (target == null) {
            this.turn = 0.0;
            this.acceleration = -bot.getVelocity().magnitude;
            return;
        }
        RelativePoint origin = target.ext.getRelativeLocation();
        double distancing_direction = 1.0;
        distancing_direction = origin.magnitude > this.goaldistance ? 0.0 : Math.PI;
        double direction = Utils.normalAbsoluteAngle((double)(origin.direction + distancing_direction));
        direction = smoother.smoothAngle2(bot.getLocation(), direction, bot.getVelocity());
        this.turn = Utils.normalRelativeAngle((double)(direction - bot.getVelocity().direction));
        if (Math.abs(this.turn) > 1.5707963267948966) {
            this.turn = Utils.normalRelativeAngle((double)(this.turn + Math.PI));
            this.acceleration = Double.NEGATIVE_INFINITY;
        } else {
            this.acceleration = Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public double getAcceleration() {
        return this.acceleration;
    }

    @Override
    public double getAngularVelocity() {
        return this.turn;
    }
}

