/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.robots;

import ags.muse.base.Rules;
import ags.rougedc.robots.IntentRobotPredictor;
import ags.rougedc.robots.VirtualRobot;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.util.ArrayList;
import java.util.List;
import robocode.Event;
import robocode.RobotStatus;
import robocode.StatusEvent;
import robocode.util.Utils;

public class StatusRobot
implements VirtualRobot {
    private static final int history_length = 2;
    private final IntentRobotPredictor intent;
    private final Rules rules;
    private long time;
    private RobotStatus status;
    private AbsolutePoint location;
    private RelativePoint velocity;
    private final List<StatusRobot> history;
    private double angularvelocity;

    public StatusRobot(Rules rules) {
        this.rules = rules;
        this.history = new ArrayList<StatusRobot>();
        this.intent = new IntentRobotPredictor(this, AbsolutePoint.fromXY(rules.BATTLEFIELD_WIDTH, rules.BATTLEFIELD_HEIGHT));
    }

    private StatusRobot(StatusRobot source) {
        this.rules = source.rules;
        this.time = source.time;
        this.status = source.status;
        if (source.location != null) {
            this.location = (AbsolutePoint)source.location.clone();
        }
        if (source.velocity != null) {
            this.velocity = (RelativePoint)source.velocity.clone();
        }
        this.history = new ArrayList<StatusRobot>(source.history);
        this.intent = new IntentRobotPredictor(this, AbsolutePoint.fromXY(this.rules.BATTLEFIELD_WIDTH, this.rules.BATTLEFIELD_HEIGHT));
    }

    public StatusRobot clone() {
        return new StatusRobot(this);
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public double getEnergy() {
        return this.status.getEnergy();
    }

    @Override
    public AbsolutePoint getLocation() {
        return this.location;
    }

    public AbsolutePoint getNextLocation() {
        return this.intent.getNextLocation();
    }

    @Override
    public RelativePoint getVelocity() {
        return this.velocity;
    }

    public double getGunHeading() {
        return this.status.getGunHeadingRadians();
    }

    public double getRadarHeading() {
        return this.status.getRadarHeadingRadians();
    }

    public double getHeading() {
        return this.velocity.getDirection();
    }

    public double getGunHeat() {
        return this.status.getGunHeat();
    }

    public double getAngularVelocity() {
        return this.angularvelocity;
    }

    public void handleEvents(Iterable<Event> i) {
        for (Event e : i) {
            if (!(e instanceof StatusEvent)) continue;
            StatusEvent event = (StatusEvent)e;
            this.history.add(this.clone());
            if (this.history.size() > 2) {
                this.history.remove(0);
            }
            if (this.velocity != null) {
                this.angularvelocity = Utils.normalRelativeAngle((double)(this.status.getHeadingRadians() - this.velocity.direction));
            }
            this.time = event.getTime();
            this.status = event.getStatus();
            this.location = AbsolutePoint.fromXY(this.status.getX(), this.status.getY());
            this.velocity = RelativePoint.fromDM(this.status.getHeadingRadians(), this.status.getVelocity());
        }
    }

    public void setMove(double arg0) {
        this.intent.setMove(arg0);
    }

    public void setTurnBody(double arg0) {
        this.intent.setTurnBody(arg0);
    }

    public StatusRobot ticksAgo(int ago) {
        if (ago == 0) {
            return this.clone();
        }
        return this.history.get(ago - 1);
    }
}

