/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.waves;

import ags.muse.base.Rules;
import ags.muse.base.StaticStorage;
import ags.muse.gun.HitrateEstimator;
import ags.muse.recon.Enemy;
import ags.muse.recon.EnemyList;
import ags.rougedc.robots.StatusRobot;
import ags.rougedc.waves.EnemyWave;
import ags.util.KdTree;
import ags.util.points.AbsolutePoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EnemyWaveManager {
    private HitrateEstimator hitrateEstimator = (HitrateEstimator)StaticStorage.get("EWMHitrateEstimator");
    private final Rules rules;
    private final StatusRobot status;
    private final EnemyList enemies;
    private final List<EnemyWave> waves;
    private final List<EnemyWave> heatwaves;
    private long gunheat_wavesfired;
    private long gunheat_wavesimmediate;
    private KdTree<Double> gunheat_firepowerstats;

    public EnemyWaveManager(Rules rules, StatusRobot status, EnemyList enemies) {
        if (this.hitrateEstimator == null) {
            this.hitrateEstimator = new HitrateEstimator();
            StaticStorage.put("EWMHitrateEstimator", this.hitrateEstimator);
        }
        this.gunheat_wavesfired = 0L;
        this.gunheat_wavesimmediate = 0L;
        Long tmp_long = (Long)StaticStorage.get("EWMGunheatWaveImmed");
        if (tmp_long != null) {
            this.gunheat_wavesimmediate = tmp_long;
        }
        if ((tmp_long = (Long)StaticStorage.get("EWMGunheatWaveFired")) != null) {
            this.gunheat_wavesfired = tmp_long;
        }
        this.gunheat_firepowerstats = (KdTree)StaticStorage.get("EWMGunheatFirepower");
        if (this.gunheat_firepowerstats == null) {
            this.gunheat_firepowerstats = new KdTree.SqrEuclid<Double>(3, null);
            StaticStorage.put("EWMGunheatFirepower", this.gunheat_firepowerstats);
        }
        this.rules = rules;
        this.status = status;
        this.enemies = enemies;
        this.waves = new ArrayList<EnemyWave>();
        this.heatwaves = new ArrayList<EnemyWave>();
    }

    public void run() {
        ArrayList<EnemyWave> killedWaves = new ArrayList<EnemyWave>();
        for (EnemyWave enemyWave : this.waves) {
            enemyWave.move();
            enemyWave.checkHit(this.status);
            if (!enemyWave.expired(this.status)) continue;
            killedWaves.add(enemyWave);
        }
        for (EnemyWave enemyWave : killedWaves) {
            this.remove(enemyWave, false);
        }
        Iterator<EnemyWave> iterator = this.heatwaves.iterator();
        while (iterator.hasNext()) {
            EnemyWave enemyWave = iterator.next();
            enemyWave.move();
            enemyWave.checkHit(this.status);
            if (!(enemyWave.getRadius() / enemyWave.getSpeed() >= 1.0)) continue;
            iterator.remove();
        }
        for (Enemy enemy : this.enemies.getBots()) {
            if (enemy.getScanAge() > 0) continue;
            double firepower = enemy.ext.getEnemyPower();
            if (firepower > 0.0) {
                this.fireWave(enemy, firepower);
            }
            this.considerGunheat(enemy);
        }
    }

    private void considerGunheat(Enemy e) {
        if (Double.isNaN(e.ext.getGunheat())) {
            return;
        }
        if (this.immediateChance() > 0.5 && e.ext.getGunheat() > 0.0 && e.ext.getGunheat() < this.rules.GUN_COOLING_RATE) {
            double distance;
            double enemyenergy;
            double myenergy = this.status.getEnergy();
            List<KdTree.Entry<Double>> entries = this.gunheat_firepowerstats.nearestNeighbor(new double[]{myenergy, enemyenergy = e.getEnergy(), distance = e.ext.getRelativeLocation().magnitude}, 1, false);
            if (entries.size() == 0) {
                return;
            }
            double firepower = (Double)entries.get((int)0).value;
            AbsolutePoint origin = e.getLocation().addRelativePoint(e.getVelocity());
            EnemyWave wave = new EnemyWave(e, origin, this.status.clone(), firepower, -1L);
            this.heatwaves.add(wave);
        }
    }

    private void fireWave(Enemy e, double firepower) {
        if (!Double.isNaN(e.ext.getCoolticks())) {
            ++this.gunheat_wavesfired;
        }
        StaticStorage.put("EWMGunheatWaveFired", this.gunheat_wavesfired);
        if (e.ext.getCoolticks() == 1L) {
            ++this.gunheat_wavesimmediate;
            StaticStorage.put("EWMGunheatWaveImmed", this.gunheat_wavesimmediate);
            double myenergy = this.status.ticksAgo(2).getEnergy();
            double enemyenergy = e.getEnergy();
            double distance = e.ext.getRelativeLocation().magnitude;
            this.gunheat_firepowerstats.addPoint(new double[]{myenergy, enemyenergy, distance}, firepower);
        }
        e.ext.firedBullet(firepower, 1);
        EnemyWave wave = new EnemyWave(e, e.ext.getLastLocation(), this.status.ticksAgo(2), firepower, 1L);
        wave.checkHit(this.status);
        this.waves.add(wave);
    }

    private double immediateChance() {
        return (double)this.gunheat_wavesimmediate / (double)this.gunheat_wavesfired;
    }

    public List<EnemyWave> getAll() {
        return this.waves;
    }

    public List<EnemyWave> getAllHeat() {
        return this.heatwaves;
    }

    public HitrateEstimator getHitrateEstimator() {
        return this.hitrateEstimator;
    }

    public void remove(EnemyWave w, boolean hit) {
        this.waves.remove(w);
        this.hitrateEstimator.waveEnd(hit, w.getOrigDist(), w.getSpeed());
    }
}

