/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.dense;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.MatrixFactory;
import org.la4j.vector.dense.BasicVector;

public class Basic1DMatrix
extends DenseMatrix {
    private static final byte MATRIX_TAG = 0;
    private double[] self;

    public static Basic1DMatrix zero(int rows, int columns) {
        return new Basic1DMatrix(rows, columns);
    }

    public static Basic1DMatrix constant(int rows, int columns, double constant) {
        double[] array = new double[rows * columns];
        Arrays.fill(array, constant);
        return new Basic1DMatrix(rows, columns, array);
    }

    public static Basic1DMatrix diagonal(int size, double diagonal) {
        double[] array = new double[size * size];
        for (int i = 0; i < size; ++i) {
            array[i * size + i] = diagonal;
        }
        return new Basic1DMatrix(size, size, array);
    }

    public static Basic1DMatrix unit(int rows, int columns) {
        return Basic1DMatrix.constant(rows, columns, 1.0);
    }

    public static Basic1DMatrix identity(int size) {
        return Basic1DMatrix.diagonal(size, 1.0);
    }

    public static Basic1DMatrix random(int rows, int columns, Random random) {
        double[] array = new double[rows * columns];
        for (int i = 0; i < rows * columns; ++i) {
            array[i] = random.nextDouble();
        }
        return new Basic1DMatrix(rows, columns, array);
    }

    public static Basic1DMatrix randomSymmetric(int size, Random random) {
        double[] array = new double[size * size];
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                double value;
                array[i * size + j] = value = random.nextDouble();
                array[j * size + i] = value;
            }
        }
        return new Basic1DMatrix(size, size, array);
    }

    public static Basic1DMatrix from1DArray(int rows, int columns, double[] array) {
        return new Basic1DMatrix(rows, columns, array);
    }

    public static Basic1DMatrix from2DArray(double[][] array) {
        int rows = array.length;
        int columns = array[0].length;
        double[] array1D = new double[rows * columns];
        int offset = 0;
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array[i], 0, array1D, offset, columns);
            offset += columns;
        }
        return new Basic1DMatrix(rows, columns, array1D);
    }

    public static Basic1DMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        if (a.rows() != b.rows() || a.columns() != c.columns() || c.rows() != d.rows() || b.columns() != d.columns()) {
            throw new IllegalArgumentException("Sides of blocks are incompatible!");
        }
        int rows = a.rows() + c.rows();
        int columns = a.columns() + b.columns();
        double[] array = new double[rows * columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (i < a.rows() && j < a.columns()) {
                    array[i * rows + j] = a.get(i, j);
                }
                if (i < a.rows() && j > a.columns()) {
                    array[i * rows + j] = b.get(i, j);
                }
                if (i > a.rows() && j < a.columns()) {
                    array[i * rows + j] = c.get(i, j);
                }
                if (i <= a.rows() || j <= a.columns()) continue;
                array[i * rows + j] = d.get(i, j);
            }
        }
        return new Basic1DMatrix(rows, columns, array);
    }

    public static Basic1DMatrix fromBinary(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (buffer.get() != 0) {
            throw new IllegalArgumentException("Can not decode Basic1DMatrix from the given byte array.");
        }
        int rows = buffer.getInt();
        int columns = buffer.getInt();
        int capacity = rows * columns;
        double[] values2 = new double[capacity];
        for (int i = 0; i < capacity; ++i) {
            values2[i] = buffer.getDouble();
        }
        return new Basic1DMatrix(rows, columns, values2);
    }

    public static Basic1DMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.BASIC_1D);
    }

    public static Basic1DMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.BASIC_1D);
    }

    public Basic1DMatrix() {
        this(0, 0);
    }

    public Basic1DMatrix(int rows, int columns) {
        this(rows, columns, new double[rows * columns]);
    }

    public Basic1DMatrix(int rows, int columns, double[] array) {
        super(rows, columns);
        this.self = array;
    }

    @Override
    public double get(int i, int j) {
        this.ensureIndexesAreInBounds(i, j);
        return this.self[i * this.columns + j];
    }

    @Override
    public void set(int i, int j, double value) {
        this.ensureIndexesAreInBounds(i, j);
        this.self[i * this.columns + j] = value;
    }

    @Override
    public void setAll(double value) {
        Arrays.fill(this.self, value);
    }

    @Override
    public void swapRows(int i, int j) {
        if (i != j) {
            for (int k = 0; k < this.columns; ++k) {
                double tmp = this.self[i * this.columns + k];
                this.self[i * this.columns + k] = this.self[j * this.columns + k];
                this.self[j * this.columns + k] = tmp;
            }
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i != j) {
            for (int k = 0; k < this.rows; ++k) {
                double tmp = this.self[k * this.columns + i];
                this.self[k * this.columns + i] = this.self[k * this.columns + j];
                this.self[k * this.columns + j] = tmp;
            }
        }
    }

    @Override
    public Vector getRow(int i) {
        double[] result = new double[this.columns];
        System.arraycopy(this.self, i * this.columns, result, 0, this.columns);
        return new BasicVector(result);
    }

    @Override
    public Matrix copyOfShape(int rows, int columns) {
        this.ensureDimensionsAreCorrect(rows, columns);
        if (this.rows < rows && this.columns == columns) {
            double[] $self = new double[rows * columns];
            System.arraycopy(this.self, 0, $self, 0, this.rows * columns);
            return new Basic1DMatrix(rows, columns, $self);
        }
        double[] $self = new double[rows * columns];
        int columnSize = columns < this.columns ? columns : this.columns;
        int rowSize = rows < this.rows ? rows : this.rows;
        for (int i = 0; i < rowSize; ++i) {
            System.arraycopy(this.self, i * this.columns, $self, i * columns, columnSize);
        }
        return new Basic1DMatrix(rows, columns, $self);
    }

    @Override
    public double[][] toArray() {
        double[][] result = new double[this.rows][this.columns];
        int offset = 0;
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.self, offset, result[i], 0, this.columns);
            offset += this.columns;
        }
        return result;
    }

    @Override
    public <T extends Matrix> T to(MatrixFactory<T> factory) {
        if (factory.outputClass == Basic1DMatrix.class) {
            return (T)((Matrix)factory.outputClass.cast(this));
        }
        return super.to(factory);
    }

    @Override
    public Matrix blankOfShape(int rows, int columns) {
        return Basic1DMatrix.zero(rows, columns);
    }

    @Override
    public byte[] toBinary() {
        int size = 9 + 8 * this.rows * this.columns;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)0);
        buffer.putInt(this.rows);
        buffer.putInt(this.columns);
        for (double value : this.self) {
            buffer.putDouble(value);
        }
        return buffer.array();
    }
}

