/*
 * Decompiled with CFR 0.152.
 */
package rdm.gunners;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rdm.gunners.Gunner;
import rdm.precepts.GunPrecept;
import rdm.state.entities.AggregateState;
import rdm.state.entities.EnemyState;
import rdm.state.entities.InstantState;
import rdm.state.entities.State;
import robocode.Bullet;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u001f\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lrdm/gunners/LinearRegressionGunner;", "Lrdm/gunners/Gunner;", "()V", "calculateGunRotation", "", "state", "Lrdm/state/entities/State;", "dispose", "", "handle", "Lrdm/precepts/GunPrecept;", "saveShot", "bullet", "Lrobocode/Bullet;", "precept", "saveShotResult", "hit", "", "(Lrobocode/Bullet;Ljava/lang/Boolean;)V", "Weights", "Commons"})
public final class LinearRegressionGunner
implements Gunner {
    private static final double BIAS = -1.071E-4;
    private static final double BEARING = 0.00605206;
    private static final double DIRECTION = -0.0325134;
    private static final double VELOCITY_PROJECTION = -8.2069E-4;
    private static final int MAX_DISTANCE = 800;
    @Deprecated
    public static final Weights Weights = new Weights(null);

    @Override
    @NotNull
    public GunPrecept handle(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        double rotation = this.calculateGunRotation(state);
        boolean shouldFire = (float)state.getInstant().getEnemy().getDistance() < (float)800;
        return new GunPrecept(shouldFire, 0.1, rotation);
    }

    @Override
    public void saveShot(@NotNull Bullet bullet, @NotNull State state, @NotNull GunPrecept precept) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(precept, "precept");
    }

    @Override
    public void saveShotResult(@NotNull Bullet bullet, @Nullable Boolean hit) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final double calculateGunRotation(State state) {
        void instant;
        State state2 = state;
        InstantState instantState = state2.component1();
        AggregateState aggregate = state2.component2();
        void var5_5 = instant;
        EnemyState enemy = var5_5.component3();
        boolean headingDirection = instant.getEnemyHeadingFromGun() >= 0.0;
        boolean velocityDirection = instant.getEnemy().getVelocity() >= 0.0;
        double direction = !(headingDirection ^ velocityDirection) ? 1.0 : 0.0;
        double velocityProjection = Math.abs(enemy.getVelocity()) * Math.sin(Math.toRadians(Math.abs(instant.getEnemyHeadingFromGun())));
        return 0.00605206 * state.getInstant().getEnemyBearingFromGun() + -0.0325134 * direction + -8.2069E-4 * velocityProjection + -1.071E-4;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lrdm/gunners/LinearRegressionGunner$Weights;", "", "()V", "BEARING", "", "BIAS", "DIRECTION", "MAX_DISTANCE", "", "VELOCITY_PROJECTION", "Commons"})
    private static final class Weights {
        private Weights() {
        }

        public /* synthetic */ Weights(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

