/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.awt.Graphics2D;
import java.util.HashMap;
import rampancy.REnemyManager;
import rampancy.RampantRobot;
import rampancy.util.REnemyRobot;

public class RDefaultEnemyManager
implements REnemyManager {
    private HashMap<String, REnemyRobot> enemies = new HashMap();
    private RampantRobot reference;

    public RDefaultEnemyManager(RampantRobot reference) {
        this.reference = reference;
    }

    public void updateReference(RampantRobot reference) {
        this.reference = reference;
        for (REnemyRobot enemy : this.enemies.values()) {
            enemy.updateReference(reference);
        }
    }

    public REnemyRobot add(String name) {
        System.out.println("Tracking enemy: " + name);
        this.enemies.put(name, new REnemyRobot(name, this.reference));
        REnemyRobot enemy = this.enemies.get(name);
        enemy.addListener(RampantRobot.getWaveManager());
        return enemy;
    }

    public REnemyRobot findOrCreateByName(String name) {
        if (this.enemies.containsKey(name)) {
            return this.get(name);
        }
        return this.add(name);
    }

    public REnemyRobot get(String name) {
        return this.enemies.get(name);
    }

    public boolean remove(String name) {
        return this.enemies.remove(name) != null;
    }

    public void resetAll() {
        for (REnemyRobot enemy : this.enemies.values()) {
            enemy.resetState();
        }
    }

    public void draw(Graphics2D g) {
        for (REnemyRobot enemy : this.enemies.values()) {
            enemy.draw(g);
        }
    }
}

