/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rampancy.standard.RDefaultKDPoint;
import rampancy.util.RRobotState;
import rampancy.util.data.kdTree.KDTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDefaultKDTree {
    public static final int NUM_NEIGHBORS = 25;
    public static final int MAX_POINTS = 2500;
    KDTree<RDefaultKDPoint> kdTree = new KDTree(RDefaultKDPoint.getComparators());

    public void rebalance() {
        List<RDefaultKDPoint> points = this.kdTree.getAllPoints();
        if (points.size() > 2500) {
            points = points.subList(points.size() - 2500, points.size() - 1);
        }
        System.out.println("Rebalancing kd-tree with " + points.size() + " points");
        this.kdTree = new KDTree<RDefaultKDPoint>(points, RDefaultKDPoint.getComparators());
    }

    public void addPoint(RRobotState state, double guessFactor) {
        this.kdTree.add(new RDefaultKDPoint(state, guessFactor));
    }

    public ArrayList<RDefaultKDPoint> getNearestPoints(RRobotState state) {
        return new ArrayList<RDefaultKDPoint>((Collection)this.kdTree.getKNearestNeighbors(new RDefaultKDPoint(state, 0.0), 25));
    }
}

