/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import java.awt.geom.Point2D;
import rampancy.util.RRectangle;
import robocode.util.Utils;

public class RPoint
extends Point2D.Double {
    public RPoint(double x, double y) {
        super(x, y);
    }

    public RPoint getCopy() {
        return (RPoint)this.clone();
    }

    public RPoint projectTo(double angle, double distance) {
        double px = this.x + Math.sin(angle) * distance;
        double py = this.y + Math.cos(angle) * distance;
        return new RPoint(px, py);
    }

    public double computeAbsoluteBearingTo(RPoint destination) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(destination.x - this.x, destination.y - this.y));
    }

    public double computeAbsoluteBearingFrom(RPoint source) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(this.x - source.x, this.y - source.y));
    }

    public RRectangle getBotRect() {
        return this.getBoundingRect(18.0);
    }

    public RRectangle getBoundingRect(double radius) {
        return new RRectangle(this, radius);
    }
}

