/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.segmentArray;

import rampancy.util.RRobotState;
import rampancy.util.data.segmentArray.RLeafSegment;
import rampancy.util.data.segmentArray.RNode;
import rampancy.util.data.segmentArray.RSegmentArray;
import rampancy.util.data.segmentArray.RSegmentFunction;

public class RBranchSegment
implements RNode {
    private RNode[] branches;
    private RSegmentFunction segmentFunction;
    private RSegmentArray reference;
    private int depth;

    public RBranchSegment(int size, RSegmentFunction segmentFunction) {
        this(size, segmentFunction, 0, null);
    }

    public RBranchSegment(int size, RSegmentFunction segmentFunction, int depth, RSegmentArray reference) {
        this.branches = new RNode[size];
        this.segmentFunction = segmentFunction;
        this.reference = reference;
        this.depth = depth;
    }

    public RLeafSegment getSegmentForState(RRobotState state) {
        int index = this.segmentFunction.getIndexForState(state, this.branches.length);
        if (this.branches[index] == null) {
            this.branches[index] = this.reference.createSegment(this.depth + 1);
        }
        return this.branches[index].getSegmentForState(state);
    }

    public RNode newInstance(RSegmentArray reference, int depth) {
        return new RBranchSegment(this.branches.length, this.segmentFunction, depth, reference);
    }
}

