/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import morbid.FieldAwareObject;
import morbid.IEnemyAnalyzer;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.Utils;

class EnemyAnalyzer
extends FieldAwareObject
implements IEnemyAnalyzer {
    private static final IEnemyAnalyzer.EnemyFireGuess[] EMPTY_ENEMYFIREGUESS_ARRAY = new IEnemyAnalyzer.EnemyFireGuess[0];
    private static final Map s_enemyStrategyCollateral;
    private static final byte[] s_collateralData;
    private static final boolean DEBUG_SERIES = false;
    private static final boolean DEBUG = false;

    public void update() {
    }

    public IEnemyAnalyzer.EnemyFireGuess[] guessEnemyFireFacts(IRobotPositionManager.ITrackedRobot enemy, long startTime) {
        if (enemy == null) {
            return EMPTY_ENEMYFIREGUESS_ARRAY;
        }
        IRobotPositionManager.ITrackedRobotTimeSeries series = enemy.getRobotTimeSeries();
        if (startTime < series.getEarliestRobotPoint().getUpdateTime()) {
            startTime = series.getEarliestRobotPoint().getUpdateTime();
        }
        if (series.size() >= 2) {
            ArrayList<IEnemyAnalyzer.EnemyFireGuess> _result = null;
            IRobotPositionManager.IUpdatedRobot point_K = null;
            IRobotPositionManager.IUpdatedRobot point_K_1 = null;
            int p = 0;
            while (p < series.size() - 1) {
                double delta;
                IRobotPositionManager.IUpdatedRobot iUpdatedRobot = point_K = p == 0 ? series.getRobotPoint(0) : point_K_1;
                if (point_K.getUpdateTime() < startTime) break;
                point_K_1 = series.getRobotPoint(p + 1);
                double knownDamage = point_K.getKnownDamage();
                if (knownDamage == 0.0) {
                    knownDamage = point_K_1.getKnownDamage();
                }
                if ((delta = point_K.getEnergy() + knownDamage - point_K_1.getEnergy()) < 0.0 && delta <= -0.1 && delta >= -3.0) {
                    double bulletPower = -delta;
                    long fireTime = point_K.getUpdateTime();
                    IEnemyAnalyzer.EnemyFireGuess guess = this.guessEnemyBulletInitParms(enemy, fireTime, bulletPower);
                    if (_result == null) {
                        _result = new ArrayList<IEnemyAnalyzer.EnemyFireGuess>(1);
                    }
                    _result.add(guess);
                }
                ++p;
            }
            if (_result != null && !_result.isEmpty()) {
                IEnemyAnalyzer.EnemyFireGuess[] result = new IEnemyAnalyzer.EnemyFireGuess[_result.size()];
                int i = 0;
                int resultLength_1 = result.length - 1;
                while (i <= resultLength_1) {
                    result[resultLength_1 - i] = (IEnemyAnalyzer.EnemyFireGuess)_result.get(i);
                    ++i;
                }
                return result;
            }
        }
        return EMPTY_ENEMYFIREGUESS_ARRAY;
    }

    public IEnemyAnalyzer.EnemyStrategyCollateral getEnemyStrategyCollateral(String ID) {
        if (ID != null) {
            Iterator i = s_enemyStrategyCollateral.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!ID.startsWith((String)entry.getKey())) continue;
                return (IEnemyAnalyzer.EnemyStrategyCollateral)entry.getValue();
            }
        }
        return null;
    }

    EnemyAnalyzer(IRobotController controller) {
        super(controller);
    }

    private IEnemyAnalyzer.EnemyFireGuess guessEnemyBulletInitParms(IRobotPositionManager.ITrackedRobot enemy, long enemyFireTime, double enemyBulletPower) {
        String enemyID = enemy.getID();
        IRobotPositionManager.IUpdatedRobot enemyFireTimePoint = enemy.getRobotTimeSeries().getRobotPointByTime(enemyFireTime);
        IRobotPositionManager.ITrackedRobot self = this.m_controller.getRobotPositionManager().getSelf();
        double directHeading = Double.NaN;
        double predictedHeading = Double.NaN;
        IRobotPositionManager.IUpdatedRobot robotFireTimePoint = self.getRobotTimeSeries().getRobotPointByTime(enemyFireTime);
        directHeading = Utils.relativeHeading(enemyFireTimePoint.getXY(), robotFireTimePoint.getXY());
        if (enemyFireTime >= self.getRobotTimeSeries().getEarliestRobotPoint().getUpdateTime()) {
            double[] self_predictor_out = new double[6];
            Utils.runSeriesPredictor(this.m_robot.out, self_predictor_out, enemyFireTimePoint.getX(), enemyFireTimePoint.getY(), enemyFireTime, Utils.bulletPowerToVelocity(enemyBulletPower), self, this.m_battleFieldWidth, this.m_battleFieldHeight);
            predictedHeading = self_predictor_out[0] > 0.0 ? self_predictor_out[1] : directHeading;
        } else {
            predictedHeading = directHeading;
        }
        EnemyFireGuessCollateral collateral = new EnemyFireGuessCollateral();
        collateral.m_directHeading = directHeading;
        collateral.m_predictedHeading = predictedHeading;
        return new IEnemyAnalyzer.EnemyFireGuess(enemyFireTime, enemyFireTimePoint.getX(), enemyFireTimePoint.getY(), enemyBulletPower, predictedHeading, collateral);
    }

    static {
        s_collateralData = new byte[]{-84, -19, 0, 5, 115, 114, 0, 17, 106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 84, 114, 101, 101, 77, 97, 112, 12, -63, -10, 62, 45, 37, 106, -26, 3, 0, 1, 76, 0, 10, 99, 111, 109, 112, 97, 114, 97, 116, 111, 114, 116, 0, 22, 76, 106, 97, 118, 97, 47, 117, 116, 105, 108, 47, 67, 111, 109, 112, 97, 114, 97, 116, 111, 114, 59, 120, 112, 112, 119, 4, 0, 0, 0, 2, 116, 0, 13, 109, 111, 114, 98, 105, 100, 46, 77, 111, 114, 98, 105, 100, 115, 114, 0, 45, 109, 111, 114, 98, 105, 100, 46, 73, 69, 110, 101, 109, 121, 65, 110, 97, 108, 121, 122, 101, 114, 36, 69, 110, 101, 109, 121, 83, 116, 114, 97, 116, 101, 103, 121, 67, 111, 108, 108, 97, 116, 101, 114, 97, 108, -37, 123, -110, -67, -106, -72, 71, -58, 2, 0, 2, 68, 0, 4, 109, 95, 115, 119, 91, 0, 4, 109, 95, 97, 119, 116, 0, 2, 91, 73, 120, 112, -64, 24, 0, 0, 0, 0, 0, 0, 117, 114, 0, 2, 91, 73, 77, -70, 96, 38, 118, -22, -78, -91, 2, 0, 0, 120, 112, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 116, 0, 7, 115, 97, 109, 112, 108, 101, 46, 115, 113, 0, 126, 0, 4, 64, 0, 0, 0, 0, 0, 0, 0, 117, 113, 0, 126, 0, 7, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 120};
        Map temp = null;
        try {
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(s_collateralData));
            temp = (Map)oin.readObject();
            oin.close();
        }
        catch (Throwable ingore) {
            temp = null;
        }
        s_enemyStrategyCollateral = temp;
    }

    public static class EnemyFireGuessCollateral {
        public double m_directHeading;
        public double m_predictedHeading;
    }
}

