/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.Message;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import math.Vect2d;
import robocode.Bullet;
import robocode.robotinterfaces.peer.IAdvancedRobotPeer;
import sim.Bot;
import sim.Data;
import sim.SelfWave;
import sim.Stat;
import util.FluentOperationQueue;
import util.FluentQueue;

public class Sequencer {
    private IAdvancedRobotPeer _peer;
    public FluentOperationQueue<Double> move;
    public FluentOperationQueue<Double> turn;
    public FluentQueue<Double> limitVelocity;
    public FluentQueue<Double> limitTurn;
    public FluentOperationQueue<Double> aim = new FluentOperationQueue(new ArrayDeque());
    public FluentOperationQueue<Double> scan = new FluentOperationQueue(new ArrayDeque());
    public FluentQueue<Color> bodyColor = new FluentQueue(new ArrayDeque());
    public FluentQueue<Color> gunColor = new FluentQueue(new ArrayDeque());
    public FluentQueue<Color> radarColor = new FluentQueue(new ArrayDeque());
    public FluentQueue<Color> scanColor = new FluentQueue(new ArrayDeque());
    public FluentQueue<Color> bulletColor = new FluentQueue(new ArrayDeque());

    public void SetPeer(IAdvancedRobotPeer peer) {
        this._peer = peer;
        this.aim.clear();
        this.scan.clear();
        this.bodyColor.clear();
        this.gunColor.clear();
        this.radarColor.clear();
        this.scanColor.clear();
        this.bulletColor.clear();
        this.move.clear();
        this.turn.clear();
        this.limitVelocity.clear();
        this.limitTurn.clear();
    }

    public Sequencer() {
        this.move = new FluentOperationQueue(new ArrayDeque());
        this.turn = new FluentOperationQueue(new ArrayDeque());
        this.limitVelocity = new FluentQueue(new ArrayDeque());
        this.limitTurn = new FluentQueue(new ArrayDeque());
    }

    public FluentQueue<Double> Aim(double turnRight) {
        return this.aim.set(turnRight);
    }

    public void Fire(Bot enemy, double bulletPower, Message message) {
        Bullet bullet = this._peer.setFire(bulletPower);
        if (bullet == null) {
            System.out.println("WARNING: attempted to fire bullet before cool.");
            return;
        }
        Point2D.Double origin = new Point2D.Double();
        origin.setLocation(Data.Robots.Self.Position);
        Vect2d bearing = Vect2d.fromHeading(enemy.Get(Stat.ABSOLUTEBEARING));
        SelfWave wave = new SelfWave(bullet, origin, bearing, message.time + 1L);
        Data.MyWaves.add(wave);
        message.respondWith(Message.Kind.SelfWaveCreated).at(message.time).about(wave).send();
    }

    public void Execute() {
        Color nextBulletColor;
        Color nextScanColor;
        Color nextRadarColor;
        Color nextGunColor;
        Color nextBodyColor;
        Double nextRadar;
        Double gun;
        Double maxTurnRate;
        Double maxVelocity;
        Double turnRight;
        Double nextMove = (Double)this.move.pop();
        if (nextMove != null) {
            this._peer.setMove(nextMove.doubleValue());
        }
        if ((turnRight = (Double)this.turn.pop()) != null) {
            this._peer.setTurnBody(turnRight.doubleValue());
        }
        if ((maxVelocity = this.limitVelocity.pop()) != null) {
            this._peer.setMaxVelocity(maxVelocity.doubleValue());
        }
        if ((maxTurnRate = this.limitTurn.pop()) != null) {
            this._peer.setMaxTurnRate(maxTurnRate.doubleValue());
        }
        if ((gun = (Double)this.aim.pop()) != null) {
            this._peer.setTurnGun(gun.doubleValue());
        }
        if ((nextRadar = (Double)this.scan.pop()) != null) {
            this._peer.setTurnRadar(nextRadar.doubleValue());
        }
        if ((nextBodyColor = this.bodyColor.pop()) != null) {
            this._peer.setBodyColor(nextBodyColor);
        }
        if ((nextGunColor = this.gunColor.pop()) != null) {
            this._peer.setGunColor(nextGunColor);
        }
        if ((nextRadarColor = this.radarColor.pop()) != null) {
            this._peer.setRadarColor(nextRadarColor);
        }
        if ((nextScanColor = this.scanColor.pop()) != null) {
            this._peer.setScanColor(nextScanColor);
        }
        if ((nextBulletColor = this.bulletColor.pop()) != null) {
            this._peer.setBulletColor(nextBulletColor);
        }
        this._peer.execute();
    }
}

