/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import math.Fath;
import math.Vect2d;
import sim.Data;

public class Maths {
    public static final double Fudge = 1.0E-11;

    public static final Point2D.Double GetIntersectionPoint(Line2D lineA, Line2D lineB) {
        double x1 = lineA.getX1();
        double y1 = lineA.getY1();
        double x2 = lineA.getX2();
        double y2 = lineA.getY2();
        double x3 = lineB.getX1();
        double y3 = lineB.getY1();
        double x4 = lineB.getX2();
        double y4 = lineB.getY2();
        Point2D.Double p = null;
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d != 0.0) {
            double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
            double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
            p = new Point2D.Double(xi, yi);
        }
        return p;
    }

    public static final double Accelerate(double velocity, double acceleration) {
        double newVelocity = velocity + acceleration;
        if (Math.signum(newVelocity) == Math.signum(acceleration)) {
            newVelocity = velocity + 1.0;
        }
        newVelocity = Math.max(Math.min(newVelocity, 8.0), -8.0);
        return newVelocity;
    }

    public static double Round(double value) {
        return Maths.RoundTo(value, 10);
    }

    public static final double RoundTo(double value, int places) {
        return BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    public static final Point2D.Double GetDirectionalWallIntersection(double x, double y, Vect2d vector) {
        Point2D.Double start = new Point2D.Double(x, y);
        vector.setMagnitude(Data.Battle.MaxDistance);
        Line2D.Double projection = vector.projectLine(start);
        Point2D.Double intersection = Data.Battle.RightWallInner.intersectsLine(projection) ? Maths.GetIntersectionPoint(Data.Battle.RightWallInner, projection) : (Data.Battle.BottomWallInner.intersectsLine(projection) ? Maths.GetIntersectionPoint(Data.Battle.BottomWallInner, projection) : (Data.Battle.LeftWallInner.intersectsLine(projection) ? Maths.GetIntersectionPoint(Data.Battle.LeftWallInner, projection) : Maths.GetIntersectionPoint(Data.Battle.TopWallInner, projection)));
        return intersection;
    }

    public static final boolean CircleIntersectsLine(double cX, double cY, double radius, Line2D.Double line) {
        boolean p1Inside = line.getP1().distance(cX, cY) < radius;
        boolean p2Inside = line.getP2().distance(cX, cY) < radius;
        return p1Inside ^ p2Inside;
    }

    public static final boolean CircleContainsLine(double cX, double cY, double radius, Line2D.Double line) {
        boolean p1Inside = line.getP1().distance(cX, cY) < radius;
        boolean p2Inside = line.getP2().distance(cX, cY) < radius;
        return p1Inside && p2Inside;
    }

    public static final double normalRelativeAngle(double rad) {
        double i = Fath.floor((rad += Math.PI) / (Math.PI * 2));
        return (rad -= i * (Math.PI * 2)) - Math.PI;
    }

    public static final double normalAbsoluteAngle(double rad) {
        double i = Fath.floor(rad / (Math.PI * 2));
        return rad -= i * (Math.PI * 2);
    }

    public static final int NextHighestPowerOfTwo(int input) {
        return Integer.highestOneBit(input) << 1;
    }

    public static final double AngleFromArcLength(double arcLength, double radius) {
        return arcLength / radius;
    }
}

