/*
 * Decompiled with CFR 0.152.
 */
package sim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java8.util.function.Predicate;
import sim.Wave;

public class WaveLookup<T extends Wave>
extends ArrayList<T> {
    private static final long serialVersionUID = -7272867288561163242L;
    private HashMap<String, T> _identifiers = new HashMap();

    protected WaveLookup() {
    }

    @Override
    public boolean add(T e) {
        this._identifiers.put(((Wave)e).identifier, e);
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.remove((T)((Wave)o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object i : c) {
            this.remove((T)((Wave)i));
        }
        return true;
    }

    @Override
    public boolean remove(T wave) {
        this._identifiers.remove(((Wave)wave).identifier);
        return super.remove(wave);
    }

    protected WaveLookup<T> filter(Predicate<T> predicate) {
        WaveLookup<Wave> output = new WaveLookup<Wave>();
        for (Wave wave : this) {
            if (!predicate.test(wave)) continue;
            output.add(wave);
        }
        return output;
    }

    public T byIdentifier(String identifier) {
        return (T)((Wave)this._identifiers.get(identifier));
    }

    public T single(Predicate<T> predicate) {
        for (Wave wave : this) {
            if (!predicate.test(wave)) continue;
            return (T)wave;
        }
        return null;
    }
}

